% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper.R
\name{grace_period}
\alias{grace_period}
\title{Strategy with Grace Period}
\usage{
grace_period(type, nperiod, condition, data, id, time_name, outcome_name)
}
\arguments{
\item{type}{a string specifying the type of grace period strategy. Possible values are "uniform" and "natural".}

\item{nperiod}{a number indicating the length of grace period.}

\item{condition}{a string specifying the logical expression, upon which is met, the treatment is initiated within \code{nperiod} time units.}

\item{data}{a data frame containing the observed data.}

\item{id}{a string specifying the ID variable name in \code{data}.}

\item{time_name}{a string specifying the time variable name in \code{data}.}

\item{outcome_name}{a string specifying the outcome variable name in \code{data}.}
}
\value{
a vector containing the intervened value of the same size as the number of rows in \code{data}.
}
\description{
This function specifies an intervention in which treatment is initiated within the grace period of \code{nperiod} time units. 
During the grace period, the treatment variable follows its natural value or initiate intervention with a uniform distribution at each time point.
}
\examples{
data <- gfoRmulaICE::compData
grace_period <- grace_period(type = "uniform", nperiod = 2, condition = "L1 == 0", 
                            data = data, id = "id", time_name = "t0", outcome_name = "Y")
}
