% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parse_methylation_from_fastq.R
\name{read_fastq}
\alias{read_fastq}
\title{Read sequence and quality information from FASTQ}
\usage{
read_fastq(filename = file.choose(), calculate_length = TRUE)
}
\arguments{
\item{filename}{\code{character}. The file to be read. Defaults to \code{\link[=file.choose]{file.choose()}} to select a file interactively.}

\item{calculate_length}{\code{logical}. Whether or not \code{sequence_length} column should be calculated and included.}
}
\value{
\code{dataframe}. A dataframe with \code{read}, \code{sequence}, \code{quality}, and optionally \code{sequence_length} columns.
}
\description{
This function simply reads a FASTQ file into a dataframe containing
columns for read ID, sequence, and quality scores.
Optionally also contains a column of sequence lengths.\cr\cr
See \code{\link{fastq_quality_scores}} for an explanation of quality.\cr\cr
Resulting dataframe can be written back to FASTQ via \code{\link[=write_fastq]{write_fastq()}}.
To read/write a modified FASTQ containing modification information
(SAM/BAM MM and ML tags) in the header lines, use
\code{\link[=read_modified_fastq]{read_modified_fastq()}} and \code{\link[=write_modified_fastq]{write_modified_fastq()}}.
}
\examples{
## Locate file
fastq_file <- system.file("extdata",
                          "example_many_sequences_raw.fastq",
                          package = "ggDNAvis")

## View file
for (i in 1:16) {
    cat(readLines(fastq_file)[i], "\n")
}

## Read file to dataframe
read_fastq(fastq_file, calculate_length = FALSE)
read_fastq(fastq_file, calculate_length = TRUE)

}
