% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_extfile.R
\name{read_extfile}
\alias{read_extfile}
\title{Reads .ext files generated by NONMEM}
\usage{
read_extfile(
  run = NA_real_,
  project = getwd(),
  file = paste0(run, ".ext"),
  path = NULL,
  read_fun = c("data.table", "read.table"),
  quiet
)
}
\arguments{
\item{run}{run a run number or run identifier}

\item{project}{project the NONMEM project directory}

\item{file}{file the `ext` file name}

\item{path}{path full path and file name for `ext` file}

\item{read_fun}{read_fun function to read the `ext` file}

\item{quiet}{Logical, if \code{FALSE} messages are printed to the console.}
}
\value{
A list with param, omega, and sigma in a format 
ready to be used.
}
\description{
Reads .ext files generated by NONMEM
}
\examples{
#project <- system.file("nonmem", package = "mrgsolve") 
#est <- read_nmext(1005, project = project) 
}
\author{
This function is based on read_nmext from mrgsolve, Original Author: Kyle T Baron.
This function has some changes to the original code:
Addition of param, "quiet", (option of pmx_msg function, from xpose package) (Line: 27)
The code was slightly adjusted to check for multiple tables and also extract SE (ITERATION == 1000000001) (Line: 44-58, Line: 86-96, respectively)
The output was also slightly adjusted to fit ggPMX output (df and df2) (Line: 105,106)
as_bmat was replaced by bmat_like to create the diagonal matrix (Line 116:142)
}
