% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02_QC_FUNs.R
\name{rBar_LCL}
\alias{rBar_LCL}
\title{Mean Subgroup Range Lower Control Limit (LCL)}
\usage{
rBar_LCL(data = data, value = value, grouping = grouping,
  formula = NULL, ...)
}
\arguments{
\item{data}{data frame to be processed}

\item{value}{numeric vector in a data frame with values of interest.}

\item{grouping}{single factor/variable to split the data frame "values" by.}

\item{formula}{a formula, such as y ~ x1 + x2, where the y variable is
numeric data to be split into groups according to the grouping x
factors/variables}

\item{...}{further arguments passed to or from other methods.}
}
\value{
A number; mean subgroup range lower control limit (LCL).
}
\description{
Calculates the mean subgroup range Lower control limit
 (UCL) used when constructing a XbarR chart.
}
\examples{
set.seed(5555)
df <- data.frame(v=rnorm(60, 0, 1), g=rep(c("A","B","C","D","E"), each=12))
rBar_LCL(data = df, formula = v~g)
}
