% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fortify-matrix.R
\name{fortify_matrix}
\alias{fortify_matrix}
\title{Build a Matrix}
\usage{
fortify_matrix(data, ..., data_arg = caller_arg(data), call = NULL)
}
\arguments{
\item{data}{An object to be converted into a matrix.}

\item{...}{Additional arguments passed to methods.}

\item{data_arg}{The argument name for \code{data}. Developers can use it to
improve messages. Not used by the user.}

\item{call}{The execution environment where \code{data} and other arguments for
the method are collected, e.g., \code{\link[rlang:stack]{caller_env()}}.
Developers can use it to improve messages. Not used by the user.}
}
\value{
A matrix.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

This function converts various objects into a matrix format. By default, it
calls \code{\link[=as.matrix]{as.matrix()}} to build a matrix.
}
\seealso{
\itemize{
\item \code{\link[=fortify_matrix.default]{fortify_matrix.default()}}
\item \code{\link[=fortify_matrix.MAF]{fortify_matrix.MAF()}}
\item \code{\link[=fortify_matrix.GISTIC]{fortify_matrix.GISTIC()}}
\item \code{\link[=fortify_matrix.list_upset]{fortify_matrix.list_upset()}}
\item \code{\link[=fortify_matrix.matrix_upset]{fortify_matrix.matrix_upset()}}
}
}
