% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gg_sf.R
\name{gg_sf}
\alias{gg_sf}
\title{Sf ggplot.}
\usage{
gg_sf(
  data = NULL,
  col = NULL,
  facet = NULL,
  group = NULL,
  stat = "sf",
  position = "identity",
  pal = NULL,
  pal_na = "#7F7F7F",
  alpha = 0.9,
  size = NULL,
  ...,
  title = NULL,
  subtitle = NULL,
  coord = ggplot2::coord_sf(),
  col_breaks = NULL,
  col_breaks_n = NULL,
  col_breaks_width = NULL,
  col_intervals = NULL,
  col_labels = NULL,
  col_legend_place = NULL,
  col_legend_ncol = NULL,
  col_legend_nrow = NULL,
  col_limits = NULL,
  col_title = NULL,
  facet_intervals = NULL,
  facet_labels = NULL,
  facet_ncol = NULL,
  facet_nrow = NULL,
  caption = NULL,
  theme = gg_theme(void = TRUE)
)
}
\arguments{
\item{data}{A sf object.}

\item{col}{Unquoted col and fill aesthetic variable.}

\item{facet}{Unquoted facet aesthetic variable.}

\item{group}{Unquoted group aesthetic variable.}

\item{stat}{Statistical transformation. A character string (e.g. "identity").}

\item{position}{Position adjustment. Either a character string (e.g."identity"), or a function (e.g. ggplot2::position_identity()).}

\item{pal}{Colours to use. A character vector of hex codes (or names).}

\item{pal_na}{Colour to use for NA values. A character vector of a hex code (or name).}

\item{alpha}{Opacity. A number between 0 and 1.}

\item{size}{Size. A number 0 upwards.}

\item{...}{Other arguments passed to the relevant ggplot2::geom_* function.}

\item{title}{Title string.}

\item{subtitle}{Subtitle string.}

\item{coord}{Coordinate system.}

\item{col_breaks}{A vector of breaks. For a categorical col variable, this links pal values with col variable values dropping those not used. For a numeric variable where col_intervals is NULL, this only affects the labels on the legend.}

\item{col_breaks_n}{For a numeric variable where col_intervals is NULL, an integer guiding the number of breaks, as calculated by the pretty function.}

\item{col_breaks_width}{For a numeric variable, the width of breaks, as calculated by the scales::fullseq function.}

\item{col_intervals}{A function to cut or chop the numeric variable into intervals, including in rlang lambda format (e.g. ~ santoku::chop_mean_sd(.x, drop = FALSE)).}

\item{col_labels}{A function to format the scale labels, including in rlang lambda format. Use ~.x to remove default transformation. If categorical, accepts a named vector (e.g. c(value = "label", ...)). Note this does not affect where col_intervals is not NULL.}

\item{col_legend_place}{The place for the legend. "r" for right, "b" for bottom, "t" for top, or "l" for left.}

\item{col_legend_ncol}{The number of columns for the legend elements.}

\item{col_legend_nrow}{The number of rows for the legend elements.}

\item{col_limits}{A vector of limits. For a categorical col variable, this links pal values with col variable values keeping those not used. For a numeric variable where col_intervals is NULL, this will make all values outside the limits coloured NA.}

\item{col_title}{Axis title string. Defaults to converting to sentence case with spaces. Use "" for no title.}

\item{facet_intervals}{A function to cut or chop the numeric variable into intervals, including in rlang lambda format (e.g. ~ santoku::chop_mean_sd(.x, drop = FALSE)).}

\item{facet_labels}{A function to format the scale labels, including in rlang lambda format. Use ~.x to remove default transformation. If categorical, accepts a named vector (e.g. c(value = "label", ...)).}

\item{facet_ncol}{The number of columns of facetted plots.}

\item{facet_nrow}{The number of rows of facetted plots.}

\item{caption}{Caption title string.}

\item{theme}{A ggplot2 theme.}
}
\value{
A ggplot object.
}
\description{
Create a sf plot with a wrapper around the ggplot2::geom_sf function.
}
\examples{
if (requireNamespace("sf", quietly = TRUE)) {
  library(ggplot2)
  nc <- sf::st_read(system.file("shape/nc.shp", package = "sf"), quiet = TRUE)

  gg_sf(nc, col = AREA)

  gg_sf(nc[1:3, ], col = AREA) +
    geom_sf_label(aes(label = AREA), fill = "white")
}

}
