% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_blanket.R
\name{set_blanket}
\alias{set_blanket}
\title{Set the style}
\usage{
set_blanket(
  ...,
  colour = "#357BA2FF",
  col_palette_d = jumble,
  col_palette_c = viridisLite::mako(n = 9, direction = -1),
  col_palette_o = scales::pal_viridis(option = "G", direction = -1),
  col_palette_na_d = "#CDC5BFFF",
  col_palette_na_c = "#988F88FF",
  col_palette_na_o = "#988F88FF",
  theme = light_mode_r(),
  theme_orientation = NULL,
  theme_axis_line_rm = TRUE,
  theme_axis_ticks_rm = TRUE,
  theme_panel_grid_rm = TRUE,
  label_case = snakecase::to_sentence_case
)
}
\arguments{
\item{...}{Provided to require argument naming, support trailing commas etc.}

\item{colour}{For most geoms, a default hex code for the colour of geoms (i.e. geoms other than "text", "label", "hline", "vline" and "abline"). Note "fill" inherits from this argument.}

\item{col_palette_d}{For a discrete scale, a character vector of hex codes.}

\item{col_palette_c}{For a continuous scale, a character vector of hex codes.}

\item{col_palette_o}{For an ordinal scale, a \verb{scales::pal_*()} function.}

\item{col_palette_na_d}{For a discrete scale, a hex code.}

\item{col_palette_na_c}{For a continuous scale, a hex code.}

\item{col_palette_na_o}{For an ordinal scale, a hex code.}

\item{theme}{A ggplot2 theme (e.g. \code{\link[=light_mode_t]{light_mode_t()}} or \code{\link[=dark_mode_r]{dark_mode_r()}}).}

\item{theme_orientation}{The orientation of plot, which affects the theme components that can be removed by the \verb{gg_*} function. Either \code{"x"} or \code{"y"}. Defaults to \code{NULL}, which lets the \verb{gg_*} function guess it based on the data.}

\item{theme_axis_line_rm}{\code{TRUE} or \code{FALSE} of whether the \verb{gg_*} function should remove the relevant axis line per the \code{theme_orientation} of the plot.}

\item{theme_axis_ticks_rm}{\code{TRUE} or \code{FALSE} of whether the \verb{gg_*} function should remove the relevant axis ticks per the \code{theme_orientation} of the plot.}

\item{theme_panel_grid_rm}{\code{TRUE} or \code{FALSE} of whether the \verb{gg_*} function should remove the relevant panel grid per the \code{theme_orientation} of the plot.}

\item{label_case}{A function to apply to a unspecified/unlabelled \code{x_label}, \code{y_label}, \code{col_label} etc. Defaults to \code{snakecase::to_sentence_case}.}
}
\value{
A globally set style.
}
\description{
Set the style by setting:
\enumerate{
\item the geom defaults, including the colour (and fill) of geoms (i.e. \code{weave_geom_defaults})
\item the colour (and fill) palettes (i.e. discrete, continuous and ordinal) (i.e. \code{weave_col_palette})
\item the theme, and how/what side-effects are to be applied (i.e. \code{weave_theme})
\item the function to apply to a unspecified/unlabelled \code{x_label}, \code{y_label}, \code{col_label} etc (i.e. \code{weave_label_case}).
}

\code{weave_font_defaults()} and \code{weave_reference_defaults()} can be used to customise "text", "label",  "abline, "vline" and "hline" geom defaults.

\code{\link[ggplot2:update_defaults]{ggplot2::update_geom_defaults()}} can be used to further fine-tune geom defaults.
}
\examples{
library(ggplot2)
library(ggblanket)
library(palmerpenguins)

set_blanket(
  theme = dark_mode_r(),
  colour = "#E7298AFF",
  col_palette_d = c("#1B9E77FF", "#D95F02FF", "#7570b3FF", "#E7298AFF",
                    "#66A61EFF", "#E6AB02FF", "#A6761DFF", "#666666FF"),
)

penguins |>
  gg_point(
    x = flipper_length_mm,
    y = body_mass_g,
  )

penguins |>
  gg_histogram(
    x = flipper_length_mm,
    col = species,
  )

}
