% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-operation-composition.R
\docType{class}
\name{operation_composition}
\alias{operation_composition}
\alias{operation_composition-class}
\title{Layer operation composition}
\value{
An \link{operation}.
}
\description{
\link{operation}s can be composed together to form chains of operations, which
when multiplied by (applied to) \link{layer-like} objects, return modified \link{layer-like} objects. In
contrast to \link{operation_product}s, compositions of operations are not
distributive over sums of \link{operation}s or \link{layer-like} objects.
}
\details{
Operation composition is achieved through function application, typically
using the pipe operator (\verb{|>}); e.g. \verb{operation1 |> operation2}.

The output of composing \pkg{ggblend} \link{operation}s depends on the types of
objects being composed:
\itemize{
\item If you compose an \link{operation} with an \link{operation}, they are merged into
a single \link{operation} that applies each \link{operation} in sequence, without
distributing over layers.
\item If you compose an \link{operation} with a \link{layer-like} object, that operation is applied
to the layer, returning a new \link{layer-like} object. The operation is applied to the
layer as a whole, not any sub-parts (e.g. sub-layers or graphical objects).
}
}
\examples{
\dontshow{old_options = options(ggblend.check_blend = FALSE)}
library(ggplot2)

# composing operations together chains them
adjust(color = "red") |> blend("multiply")

# unlike multiplication, composition does not follow the distributive law
mult_op = (adjust(aes(y = 11 -x), color = "skyblue") + 1) * blend("multiply")
mult_op

comp_op = (adjust(aes(y = 11 -x), color = "skyblue") + 1) |> blend("multiply")
comp_op

# multiplication by a geom returns a modified version of that geom
data.frame(x = 1:10) |>
  ggplot(aes(x = x, y = x)) +
  geom_line(linewidth = 10, color = "red") * comp_op
\dontshow{options(old_options)}
}
