% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggbump.R
\name{geom_bump}
\alias{geom_bump}
\title{geom_bump

Creates a ggplot that makes a smooth rank over time. To change the `smooth`
argument you need to put it outside of the `aes` of the geom. Uses the x and y aestethics.}
\usage{
geom_bump(
  mapping = NULL,
  data = NULL,
  geom = "line",
  position = "identity",
  na.rm = FALSE,
  show.legend = NA,
  smooth = 8,
  direction = "x",
  inherit.aes = TRUE,
  ...
)
}
\arguments{
\item{mapping}{provide you own mapping. both x and y need to be numeric.}

\item{data}{provide you own data}

\item{geom}{change geom}

\item{position}{change position}

\item{na.rm}{remove missing values}

\item{show.legend}{show legend in plot}

\item{smooth}{how much smooth should the curve have? More means steeper curve.}

\item{direction}{the character x or y depending of smoothing direction}

\item{inherit.aes}{should the geom inherits aestethics}

\item{...}{other arguments to be passed to the geom}
}
\value{
ggplot layer
}
\description{
geom_bump

Creates a ggplot that makes a smooth rank over time. To change the `smooth`
argument you need to put it outside of the `aes` of the geom. Uses the x and y aestethics.
}
\examples{
library(ggplot2)
df <- data.frame(country = c(
  "India", "India", "India",
  "Sweden", "Sweden", "Sweden",
  "Germany", "Germany", "Germany",
  "Finland", "Finland", "Finland"),
year = c(2011, 2012, 2013,
2011, 2012, 2013,
2011, 2012, 2013,
2011, 2012, 2013),
rank = c(4, 2, 2, 3, 1, 4, 2, 3, 1, 1, 4, 3))

ggplot(df, aes(year, rank, color = country)) +
  geom_point(size = 10) +
  geom_bump(size = 2)

}
