% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dumbbell_chart.R
\name{dumbbell_chart}
\alias{dumbbell_chart}
\title{Dumbbell Chart}
\usage{
dumbbell_chart(
  data,
  x,
  y1,
  y2,
  line_size = 1.5,
  line_color = "lightgray",
  point_size = 4,
  point_colors = c("#1F77B4", "#FF7F0E"),
  sort = TRUE,
  horizontal = TRUE,
  limit = NULL,
  legend = TRUE,
  legend_labels = waiver()
)
}
\arguments{
\item{data}{Dataset to use for the dumbbell chart}

\item{x}{\code{character} or \code{factor} column of \code{data}}

\item{y1}{\code{numeric} column of \code{data} representing the dumbbell end}

\item{y2}{\code{numeric} column of \code{data} representing the dumbbell start}

\item{line_size}{\code{numeric}. Line width}

\item{line_color}{\code{character}. Line color}

\item{point_size}{\code{numeric}. Point size}

\item{point_colors}{\code{numeric}. Point color}

\item{sort}{\code{logical}. Should the data be sorted by \code{y2} before
plotting?}

\item{horizontal}{\code{logical}. Should the plot be displayed horizontally?}

\item{limit}{\code{integer}. If a value for limit is provided only the first
\code{limit} records will be displayed}

\item{legend}{\code{logical}. Should a legend be displayed?}

\item{legend_labels}{\code{character}. Custom labels to be displayed in the
legend}
}
\value{
An object of class \code{ggplot}
}
\description{
Easily create a dumbbell chart
}
\examples{
if (requireNamespace("tidyr") && requireNamespace("gapminder")) {
  library(magrittr)
  data(gapminder, package = "gapminder")

  # Data has to be in wide format
  pop <- gapminder \%>\%
    dplyr::filter(year \%in\% c(1952, 2007)) \%>\%
    tidyr::pivot_wider(
      id_cols = country,
      values_from = pop,
      names_from = year,
      names_prefix = "pop_"
    )

  withAutoprint({
    dumbbell_chart(pop, country, pop_1952, pop_2007)

    # Display only the top 10 countries in terms of population in 2007
    dumbbell_chart(pop, country, pop_1952, pop_2007, limit = 10)

    # Change line and point color
    dumbbell_chart(pop, country, pop_1952, pop_2007, limit = 10,
                 line_color = "lightgray", point_color = c("lightgray", "black"))

    # Add custom legend labels
    dumbbell_chart(pop, country, pop_1952, pop_2007, limit = 10,
                   legend_labels = c("1952", "2007"))

    # Increase line width and point size
    dumbbell_chart(pop, country, pop_1952, pop_2007, limit = 10,
                   line_size = 2, point_size = 5)
  }, echo = FALSE)
}

}
\author{
Thomas Neitmann
}
