% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/theme.R
\name{theme_ggcharts}
\alias{theme_ggcharts}
\title{Theme ggcharts}
\usage{
theme_ggcharts(
  base_size = 14,
  base_family = "",
  axis = "",
  ticks = "",
  grid = ""
)
}
\arguments{
\item{base_size}{\code{numeric}. Base font size in pt}

\item{base_family}{\code{character}. Base font family}

\item{axis}{\code{character}. Where to draw an axis line}

\item{ticks}{\code{character}. Where to draw axis ticks}

\item{grid}{\code{character}. Where to draw grid lines}
}
\value{
An object of class \code{theme}
}
\description{
The default ggcharts theme
}
\details{
\code{theme_ggcharts} is the default theme used when creating any plot with
\code{ggcharts}.
}
\examples{
library(ggplot2)
library(dplyr)

scatter <- ggplot(mtcars, aes(hp, mpg)) +
  geom_point(color = "steelblue")

scatter + theme_ggcharts()

scatter + theme_ggcharts(grid = "XY")

scatter + theme_ggcharts(axis = "xy", ticks = "xy")

bar_chart(ggplot2::diamonds, cut) +
  theme_ggcharts(axis = "y", grid = "Y")

column_chart(ggplot2::diamonds, cut) +
  theme_ggcharts(axis = "x", grid = "X")

ggcharts::biomedicalrevenue \%>\%
  filter(company == "Roche") \%>\%
  ggplot(aes(year, revenue)) +
  geom_line(color = "steelblue", size = 1) +
  scale_y_continuous(expand = expand_scale(c(0, .05))) +
  theme_ggcharts(grid = "X", axis = "x", ticks = "x")

}
\seealso{
For more details see the 'theme' vignette:
\code{vignette("theme", package = "ggcharts")}
}
\author{
Thomas Neitmann
}
