% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/colliders.R
\name{Colliders}
\alias{Colliders}
\alias{node_collider}
\alias{ggdag_collider}
\title{Find colliders}
\usage{
node_collider(.dag, as_factor = TRUE, ...)

ggdag_collider(
  .tdy_dag,
  ...,
  edge_type = "link_arc",
  node_size = 16,
  text_size = 3.88,
  label_size = text_size,
  text_col = "white",
  label_col = text_col,
  node = TRUE,
  stylized = FALSE,
  text = TRUE,
  use_labels = NULL
)
}
\arguments{
\item{.dag, .tdy_dag}{input graph, an object of class \code{tidy_dagitty} or
\code{dagitty}}

\item{as_factor}{treat \code{collider} variable as factor}

\item{...}{additional arguments passed to \code{tidy_dagitty()}}

\item{edge_type}{a character vector, the edge geom to use. One of:
"link_arc", which accounts for directed and bidirected edges, "link",
"arc", or "diagonal"}

\item{node_size}{size of DAG node}

\item{text_size}{size of DAG text}

\item{label_size}{size of label text}

\item{text_col}{color of DAG text}

\item{label_col}{color of label text}

\item{node}{logical. Should nodes be included in the DAG?}

\item{stylized}{logical. Should DAG nodes be stylized? If so, use
\code{geom_dag_nodes} and if not use \code{geom_dag_point}}

\item{text}{logical. Should text be included in the DAG?}

\item{use_labels}{a string. Variable to use for \code{geom_dag_label_repel()}.
Default is \code{NULL}.}
}
\value{
a \code{tidy_dagitty} with a \code{collider} column for
colliders or a \code{ggplot}
}
\description{
Detects any colliders given a DAG.
\code{node_collider} tags colliders and \code{ggdag_collider} plots all
exogenous variables.
}
\examples{
dag <- dagify(m ~ x + y, y ~ x)

node_collider(dag)
ggdag_collider(dag)

}
