% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat_sample_slabinterval.R
\name{stat_sample_slabinterval}
\alias{stat_sample_slabinterval}
\alias{stat_halfeye}
\alias{stat_eye}
\alias{stat_ccdfinterval}
\alias{stat_cdfinterval}
\alias{stat_gradientinterval}
\alias{stat_histinterval}
\alias{stat_slab}
\title{Distribution + interval plots (eye plots, half-eye plots, CCDF barplots, etc) for samples (ggplot stat)}
\usage{
stat_sample_slabinterval(
  mapping = NULL,
  data = NULL,
  geom = "slabinterval",
  position = "identity",
  ...,
  slab_type = c("pdf", "cdf", "ccdf", "histogram"),
  adjust = 1,
  trim = TRUE,
  breaks = "Sturges",
  outline_bars = FALSE,
  orientation = NA,
  limits = NULL,
  n = 501,
  interval_function = NULL,
  interval_args = list(),
  point_interval = median_qi,
  .width = c(0.66, 0.95),
  na.rm = FALSE,
  show.legend = c(size = FALSE),
  inherit.aes = TRUE
)

stat_halfeye(...)

stat_eye(..., side = "both")

stat_ccdfinterval(
  ...,
  slab_type = "ccdf",
  justification = 0.5,
  side = "topleft",
  normalize = "none"
)

stat_cdfinterval(
  ...,
  slab_type = "cdf",
  justification = 0.5,
  side = "topleft",
  normalize = "none"
)

stat_gradientinterval(
  mapping = NULL,
  data = NULL,
  geom = "slabinterval",
  position = "identity",
  ...,
  justification = 0.5,
  thickness = 1,
  show.legend = c(size = FALSE, slab_alpha = FALSE),
  inherit.aes = TRUE
)

stat_histinterval(..., slab_type = "histogram")

stat_slab(
  mapping = NULL,
  data = NULL,
  geom = "slab",
  position = "identity",
  ...,
  show.legend = NA,
  inherit.aes = TRUE
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2:aes]{aes()}} or
\code{\link[ggplot2:aes_]{aes_()}}. If specified and \code{inherit.aes = TRUE} (the
default), it is combined with the default mapping at the top level of the
plot. You must supply \code{mapping} if there is no plot mapping.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[ggplot2:ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[ggplot2:fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame}, and
will be used as the layer data. A \code{function} can be created
from a \code{formula} (e.g. \code{~ head(.x, 10)}).}

\item{geom}{Use to override the default connection between
\code{stat_slabinterval} and \code{\link[=geom_slabinterval]{geom_slabinterval()}}}

\item{position}{Position adjustment, either as a string, or the result of
a call to a position adjustment function.}

\item{...}{Other arguments passed to \code{\link[=layer]{layer()}}. They may also be arguments to the paired geom
(e.g., \code{\link[=geom_pointinterval]{geom_pointinterval()}})}

\item{slab_type}{The type of slab function to calculate: probability density (or mass) function (\code{"pdf"}),
cumulative distribution function (\code{"cdf"}), complementary CDF (\code{"ccdf"}), or histogram (\code{"histogram"}.}

\item{adjust}{If \code{slab_type} is \code{"pdf"}, bandwidth for the density estimator is adjusted by multiplying it
by this value. See \code{\link[=density]{density()}} for more information.}

\item{trim}{If \code{slab_type} is \code{"pdf"}, should the density estimate be trimmed to the range of the
input data? Default \code{TRUE}.}

\item{breaks}{If \code{slab_type} is \code{"histogram"}, the \code{breaks} parameter that is passed to
\code{\link[=hist]{hist()}} to determine where to put breaks in the histogram.}

\item{outline_bars}{If \code{slab_type} is \code{"histogram"}, \code{outline_bars} determines if outlines in between
the bars are drawn when the \code{slab_color} aesthetic is used. If \code{FALSE} (the default), the outline
is drawn only along the tops of the bars; if \code{TRUE}, outlines in between bars are also drawn.}

\item{orientation}{Whether this geom is drawn horizontally (\code{"horizontal"}) or
vertically (\code{"vertical"}). The default, \code{NA}, automatically detects the orientation based on how the
aesthetics are assigned, and should generally do an okay job at this. When horizontal (resp. vertical),
the geom uses the \code{y} (resp. \code{x}) aesthetic to identify different groups, then for each group uses
the \code{x} (resp. \code{y}) aesthetic and the \code{thickness} aesthetic to draw a function as an slab, and draws
points and intervals horizontally (resp. vertically) using the \code{xmin}, \code{x}, and \code{xmax} (resp.
\code{ymin}, \code{y}, and \code{ymax}) aesthetics. For compatibility with the base
ggplot naming scheme for \code{orientation}, \code{"x"} can be used as an alias for \code{"vertical"} and \code{"y"} as an alias for
\code{"horizontal"} (tidybayes had an \code{orientation} parameter before ggplot did, and I think the tidybayes naming
scheme is more intuitive: \code{"x"} and \code{"y"} are not orientations and their mapping to orientations is, in my
opinion, backwards; but the base ggplot naming scheme is allowed for compatibility).}

\item{limits}{Limits for \code{slab_function}, as a vector of length two. These limits are combined with those
computed by the \code{limits_function} as well as the limits defined by the scales of the plot to determine the
limits used to draw the slab functions: these limits specify the maximal limits; i.e., if specified, the limits
will not be wider than these (but may be narrower). Use \code{NA} to leave a limit alone; e.g.
\code{limits = c(0, NA)} will ensure that the lower limit does not go below 0.}

\item{n}{Number of points at which to evaluate \code{slab_function}}

\item{interval_function}{Custom function for generating intervals (for most common use cases the \code{point_interval}
argument will be easier to use). This function takes a data frame of aesthetics and a \code{.width} parameter (a vector
of interval widths), and returns a data frame with
columns \code{.width} (from the \code{.width} vector), \code{.value} (point summary) and \code{.lower} and \code{.upper}
(endpoints of the intervals, given the \code{.width}). Output will be converted to the appropriate \code{x}- or
\code{y}-based aesthetics depending on the value of \code{orientation}. If \code{interval_function} is \code{NULL},
\code{point_interval} is used instead.}

\item{interval_args}{Additional arguments passed to \code{interval_function} or \code{point_interval}.}

\item{point_interval}{A function from the \code{\link[=point_interval]{point_interval()}} family (e.g., \code{median_qi},
\code{mean_qi}, etc). This function should take in a vector of value, and should obey the
\code{.width} and \code{.simple_names} parameters of \code{\link[=point_interval]{point_interval()}} functions, such that when given
a vector with \code{.simple_names = TRUE} should return a data frame with variables \code{.value}, \code{.lower},
\code{.upper}, and \code{.width}. Output will be converted to the appropriate \code{x}- or \code{y}-based aesthetics
depending on the value of \code{orientation}. See the \code{\link[=point_interval]{point_interval()}} family of functions for
more information.}

\item{.width}{The \code{.width} argument passed to \code{interval_function} or \code{point_interval}.}

\item{na.rm}{If \code{FALSE}, the default, missing values are removed with a warning. If \code{TRUE}, missing
values are silently removed.}

\item{show.legend}{Should this layer be included in the legends? Default is \code{c(size = FALSE)}, unlike most geoms,
to match its common use cases. \code{FALSE} hides all legends, \code{TRUE} shows all legends, and \code{NA} shows only
those that are mapped (the default for most geoms).}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[ggplot2:borders]{borders()}}.}

\item{side}{Which side to draw the slab on. \code{"topright"}, \code{"top"}, and \code{"right"} are synonyms
which cause the slab to be drawn on the top or the right depending on if \code{orientation} is \code{"horizontal"}
or \code{"vertical"}. \code{"bottomleft"}, \code{"bottom"}, and \code{"left"} are synonyms which cause the slab
to be drawn on the bottom or the left depending on if \code{orientation} is \code{"horizontal"} or
\code{"vertical"}. \code{"topleft"} causes the slab to be drawn on the top or the left, and \code{"bottomright"}
causes the slab to be drawn on the bottom or the right. \code{"both"} draws the slab mirrored on both
sides (as in a violin plot).}

\item{justification}{Justification of the interval relative to the slab, where \code{0} indicates bottom/left
justification and \code{1} indicates top/right justification (depending on \code{orientation}). If \code{justification}
is \code{NULL} (the default), then it is set automatically based on the value of \code{side}: when \code{side} is
\code{"top"}/\code{"right"} \code{justification} is set to \code{0}, when \code{side} is \code{"bottom"}/\code{"left"}
\code{justification} is set to \code{1}, and when \code{side} is \code{"both"} \code{justification} is set to
\code{0.5}.}

\item{normalize}{How to normalize heights of functions input to the \code{thickness} aesthetic. If \code{"all"}
(the default), normalize so that the maximum height across all data is \code{1}; if \code{"panels"}, normalize within
panels so that the maximum height in each panel is \code{1}; if \code{"xy"}, normalize within
the x/y axis opposite the \code{orientation} of this geom so that the maximum height at each value of the
opposite axis is \code{1}; if \code{"groups"}, normalize within values of the opposite axis and within
groups so that the maximum height in each group is \code{1}; if \code{"none"}, values are taken as is with no
normalization (this should probably only be used with functions whose values are in [0,1], such as CDFs).}

\item{thickness}{Override for the \code{thickness} aesthetic in \code{\link[=geom_slabinterval]{geom_slabinterval()}}: the thickness
of the slab at each x / y value of the slab (depending on \code{orientation}).}
}
\value{
A \link[ggplot2:ggplot2-ggproto]{ggplot2::Stat} representing a slab or combined slab+interval geometry which can
be added to a \code{\link[=ggplot]{ggplot()}} object.
}
\description{
Stats for computing densities and CDFs + intervals from samples for use with
\code{\link[=geom_slabinterval]{geom_slabinterval()}}. Useful for creating eye plots, half-eye plots,
CCDF bar plots etc.
}
\details{
A highly configurable stat for generating a variety of plots that combine a "slab"
that summarizes a sample plus an interval. Several "shortcut" stats are provided
which combine multiple options to create useful geoms, particularly \emph{eye} plots
(a combination of a violin plot and interval), \emph{half-eye} plots (a density plus interval),
and \emph{CCDF bar plots} (a complementary CDF plus interval). These can be
handy for visualizing posterior distributions in Bayesian inference, amongst other things.

The shortcut stat names follow the pattern \code{stat_[name]}.

Stats include:

\itemize{
\item \code{stat_eye}: Eye plots (violin + interval)
\item \code{stat_halfeye}: Half-eye plots (density + interval)
\item \code{stat_ccdfinterval}: CCDF bar plots (CCDF + interval)
\item \code{stat_cdfinterval}: CDF bar plots (CDF + interval)
\item \code{stat_gradientinterval}: Density gradient + interval plots
\item \code{stat_histinterval}: Histogram + interval plots
\item \code{stat_pointinterval}: Point + interval plots
\item \code{stat_interval}: Interval plots
}
}
\section{Aesthetics}{

These stats support the following aesthetics:
\itemize{
\item \code{x}
\item \code{y}
\item \code{datatype}
\item \code{thickness}
\item \code{size}
\item \code{group}
}
In addition, in their default configuration (paired with \code{\link[=geom_slabinterval]{geom_slabinterval()}}) the following aesthetics are supported by the underlying geom:
\itemize{
\item \code{x}
\item \code{y}
\item \code{datatype}
\item \code{alpha}
\item \code{colour}
\item \code{colour_ramp}
\item \code{linetype}
\item \code{fill}
\item \code{shape}
\item \code{stroke}
\item \code{point_colour}
\item \code{point_fill}
\item \code{point_alpha}
\item \code{point_size}
\item \code{size}
\item \code{interval_colour}
\item \code{interval_alpha}
\item \code{interval_size}
\item \code{interval_linetype}
\item \code{slab_size}
\item \code{slab_colour}
\item \code{slab_fill}
\item \code{slab_alpha}
\item \code{slab_linetype}
\item \code{fill_ramp}
\item \code{ymin}
\item \code{ymax}
\item \code{xmin}
\item \code{xmax}
\item \code{width}
\item \code{height}
\item \code{thickness}
\item \code{group}
}
See examples of some of these aesthetics in action in \code{vignette("slabinterval")}.
Learn more about the sub-geom aesthetics (like \code{interval_color}) in the \link[ggdist]{scales} documentation.
Learn more about basic ggplot aesthetics in \code{vignette("ggplot2-specs")}.
}

\section{Computed Variables}{

\itemize{
\item \code{x} or \code{y}: For slabs, the input values to the slab function.
For intervals, the point summary from the interval function. Whether it is \code{x} or \code{y} depends on \code{orientation}
\item \code{xmin} or \code{ymin}: For intervals, the lower end of the interval from the interval function.
\item \code{xmax} or \code{ymax}: For intervals, the upper end of the interval from the interval function.
\item \code{f}: For slabs, the output values from the slab function (such as the PDF, CDF, or CCDF),
determined by \code{slab_type}.
\item \code{pdf}: For slabs, the probability density function.
\item \code{cdf}: For slabs, the cumulative distribution function.
\item \code{n}: For slabs, the number of data points summarized into that slab.
}
}

\examples{

library(dplyr)
library(tidyr)
library(ggplot2)

# consider the following example data:
set.seed(1234)
df = tribble(
  ~group, ~subgroup, ~value,
  "a",          "h", rnorm(500, mean = 5),
  "b",          "h", rnorm(500, mean = 7, sd = 1.5),
  "c",          "h", rnorm(500, mean = 8),
  "c",          "i", rnorm(500, mean = 9),
  "c",          "j", rnorm(500, mean = 7)
) \%>\%
  unnest(value)

# here are vertical eyes:
df \%>\%
  ggplot(aes(x = group, y = value)) +
  stat_eye()

# note the sample size is not automatically incorporated into the
# area of the densities in case one wishes to plot densities against
# a reference (e.g. a prior generated by a stat_dist_... function).
# But you may wish to account for sample size if using these geoms
# for something other than visualizing posteriors; in which case
# you can use stat(f*n):
df \%>\%
  ggplot(aes(x = group, y = value)) +
  stat_eye(aes(thickness = stat(f*n)))

# see vignette("slabinterval") for many more examples.

}
\seealso{
See \code{\link[=geom_slabinterval]{geom_slabinterval()}} for more information on the geom these stats
use by default and some of the options they have. See \code{\link[=stat_dist_slabinterval]{stat_dist_slabinterval()}}
for the versions of these stats that can be used on analytical distributions.
See \code{vignette("slabinterval")} for a variety of examples of use.
}
