% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggdmc_utils.R
\name{censor}
\alias{censor}
\title{Censor missing values and RT outliers}
\usage{
censor(x, xlim = c(0, Inf))
}
\arguments{
\item{x}{a data frame for a design cell.}

\item{xlim}{the lower and upper boundaries for censoring}
}
\description{
\code{censor} requests a data frame with at lease three columns, stimulus
type (S factor), response/accumulator type (R factor) and response time
(RT, double) as input \code{data}. It adding a boolean
column by scoring R column against S column. This produces a C column.
Otherwise plots each response. When NAs occur, \code{censor} reports a
summary of p(NA).
}
\examples{
model <- model.dmc(
   p.map     = list(a="1",v="1",z="1",d="1",sz="1",sv="1", t0="1",st0="1"),
   constants = c(st0=0,d=0),
   match.map = list(M=list(s1="r1",s2="r2")),
   factors   = list(S=c("s1","s2")),
   responses = c("r1","r2"),
   type      = "rd")

pVec <- c(a=1,v=1, z=0.5, sz=0.25, sv=0.2,t0=.15)
dat1 <- simulate(model, nsim=1e2, p.vector=pVec)
mdi1 <- data.model.dmc(dat1, model)

## 1. xlim=c(.2, 3) defines the censored lower and upper bounds at .2 s and
## 3 s
## 2. mdi1[mdi1$S=="s1", ] extracts the data frame with rows/trials equal to
## "s1".
mdi1.s1 <- mdi1[mdi1$S=="s1", ]
censored.s1 <- censor(mdi1.s1, xlim=c(.2, 3))
head(censored.s1)
## Below is printed by dplyr::tbl_df(censored.s1)
## Source: local data frame [94 x 3]
##         S      R        RT
##    (fctr) (fctr)     (dbl)
## 1      s1     r2 0.3370070
## 2      s1     r1 0.2956996
## 3      s1     r2 0.2128732
## 4      s1     r1 0.3710657
## 5      s1     r2 0.3083122
## 6      s1     r2 0.2997714
## 7      s1     r1 0.4123926
## 8      s1     r1 0.2356586
## 9      s1     r2 0.4721079
## 10     s1     r2 0.3524906
## ..    ...    ...       ...
}
\keyword{censor}

