% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{rprior}
\alias{rprior}
\title{Generate Random Numbers from Prior Probability Distribution}
\usage{
rprior(pPrior, n)
}
\arguments{
\item{pPrior}{a p.prior list}

\item{n}{how many random number to generate}
}
\value{
a double matrix with nrow equal to the number of random numbers and
ncol equal to the number of EAM parameters (npar)
}
\description{
\code{dprior} matches 5 types of string: \code{tnorm}, \code{beta_lu},
\code{gamma_l}, \code{lnorm_l}, and \code{constant} to determine which
density functions to call. \code{dprior} calls beta, gamma, log-normal
density functions via R API.  For truncated normal density, \code{dprior}
calls \code{dtn_scalar}, an internal Rcpp function built specific for
ggdmc. Whetehr log the probability density is determined by the boolean
\code{log} sent in via p.prior.  This function is akin to DMC's
\code{log.prior.dmc}.
}
\examples{
ddm.prior <- prior.p.dmc(
dists = c("tnorm", "tnorm", "beta", "tnorm", "beta", "beta"),
  p1    = c(a = 1, v = 0, z = 1, sz = 1, sv = 1, t0 = 1),
  p2    = c(a = 1, v = 2, z = 1, sz = 1, sv = 1, t0 = 1),
  lower = c(0,-5, NA, NA, 0, NA),
  upper = c(2, 5, NA, NA, 2, NA))

view(ddm.prior)
##      mean sd lower upper log    dist  untrans
##   a     1  1     0     2   1   tnorm identity
##   v     0  2    -5     5   1   tnorm identity
##   z     1  1     0     1   1 beta_lu identity
##   sz    1  1  -Inf   Inf   1   tnorm identity
##   sv    1  1     0     2   1 beta_lu identity
##   t0    1  1     0     1   1 beta_lu identity

rprior(ddm.prior, 9)
##               a           v         z         sz        sv         t0
## [1,] 0.97413686  0.78446178 0.9975199 -0.5264946 0.5364492 0.55415052
## [2,] 0.72870190  0.97151662 0.8516604  1.6008591 0.3399731 0.96520848
## [3,] 1.63153685  1.96586939 0.9260939  0.7041254 0.4138329 0.78367440
## [4,] 1.55866180  1.43657110 0.6152371  0.1290078 0.2957604 0.23027759
## [5,] 1.32520281 -0.07328408 0.2051155  2.4040387 0.9663111 0.06127237
## [6,] 0.49628528 -0.19374770 0.5142829  2.1452972 0.4335482 0.38410626
## [7,] 0.03655549  0.77223432 0.1739831  1.4431507 0.6257398 0.63228368
## [8,] 0.71197612 -1.15798082 0.8265523  0.3813370 0.4465184 0.23955415
## [9,] 0.38049166  3.32132034 0.9888108  0.9684292 0.8437480 0.13502154
}

