% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analysis.R
\name{summary.model}
\alias{summary.model}
\title{Summarise posterior samples}
\usage{
\method{summary}{model}(object, hyper = FALSE, start = 1, end = NA,
  hmeans = FALSE, hci = FALSE, prob = c(0.025, 0.25, 0.5, 0.75,
  0.975), recovery = FALSE, ps = NA, type = 1, verbose = FALSE,
  digits = 2, ...)
}
\arguments{
\item{object}{posterior samples}

\item{hyper}{whether to summarise hyper parameters}

\item{start}{start from which iteration.}

\item{end}{end at which iteration. For example, set
\code{start = 101} and \code{end = 1000}, instructs the function to
calculate from 101 to 1000 iteration.}

\item{hmeans}{a boolean switch indicating to calculate mean of hyper
parameters}

\item{hci}{boolean switch; whether to calculate credible intervals of
hyper parameters}

\item{prob}{a numeric vector, indicating the quantiles to calculate}

\item{recovery}{a boolean switch indicating if samples are from a recovery
study}

\item{ps}{true parameter values.  This is only for recovery studies}

\item{type}{calculate type 1 or 2 hyper parameters}

\item{verbose}{print more information}

\item{digits}{printing digits}

\item{...}{other arguments}
}
\description{
This calls seven different variants of summary function to summarise
posterior samples
}
\examples{
\dontrun{
est1 <- summary(hsam[[1]], FALSE)
est2 <- summary(hsam[[1]], FALSE, 1, 100)

est3 <- summary(hsam)
est4 <- summary(hsam, verbose = TRUE)
est5 <- summary(hsam, verbose = FALSE)

hest1 <- summary(hsam, TRUE)
}
}
