% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fortify_surv.R
\name{fortify.aareg}
\alias{fortify.aareg}
\title{Convert \code{survival::aareg} to \code{data.frame}}
\usage{
\method{fortify}{aareg}(model, data = NULL, maxtime = NULL,
  surv.connect = TRUE, melt = FALSE, ...)
}
\arguments{
\item{model}{\code{survival::aareg} instance}

\item{data}{original dataset, if needed}

\item{maxtime}{truncate the input to the model at time "maxtime"}

\item{surv.connect}{logical frag indicates whether connects survival curve to the origin}

\item{melt}{Logical flag indicating whether to melt each timeseries as variable}

\item{...}{other arguments passed to methods}
}
\value{
data.frame
}
\description{
Convert \code{survival::aareg} to \code{data.frame}
}
\examples{
library(survival)
fortify(aareg(Surv(time, status) ~ age + sex + ph.ecog, data = lung, nmin = 1))
fortify(aareg(Surv(time, status) ~ age + sex + ph.ecog, data = lung, nmin = 1), melt = TRUE)
}
