% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/facet_manual.R
\name{facet_manual}
\alias{facet_manual}
\title{Manual layout for panels}
\usage{
facet_manual(
  facets,
  design = NULL,
  widths = NULL,
  heights = NULL,
  respect = FALSE,
  drop = TRUE,
  strip.position = "top",
  scales = "fixed",
  axes = "margins",
  remove_labels = "none",
  labeller = "label_value",
  trim_blank = TRUE,
  strip = strip_vanilla()
)
}
\arguments{
\item{facets}{A set of variables or expressions quoted by \code{\link[ggplot2:vars]{vars()}}
and defining faceting groups on the rows or columns dimension.
The variables can be named (the names are passed to \code{labeller}).

For compatibility with the classic interface, can also be a
formula or character vector. Use either a one sided formula, \code{~a + b},
or a character vector, \code{c("a", "b")}.}

\item{design}{Specification of panel areas in the layout. Can either be
specified as a \code{character(1)} string or as a \code{matrix}. See examples.}

\item{widths, heights}{A \code{numeric} or \code{unit} vector setting the sizes of
panels. A \code{numeric} vector is converted to relative \code{"null"} units.
Alternatively, when \code{NULL} (default), the sizes are set per instructions of
coord or theme aspect ratio. Note that these widths and heights apply to
the cells where panels can be drawn. In between such cells, room will be
made to fit plot decoration such as paddings, axes and strips.}

\item{respect}{A \code{logical(1)}. If \code{TRUE}, widths and heights specified in
\code{"null"} units are proportional. If \code{FALSE}, \code{"null"} units in the x- and
y-directions can vary independently. Alternatively, when \code{NULL}, the
\code{respect} parameter takes instructions from the coord or theme.}

\item{drop}{If \code{TRUE}, the default, all factor levels not used in the
data will automatically be dropped. If \code{FALSE}, all factor levels
will be shown, regardless of whether or not they appear in the data.}

\item{strip.position}{By default, the labels are displayed on the top of
the plot. Using \code{strip.position} it is possible to place the labels on
either of the four sides by setting \code{strip.position = c("top",
  "bottom", "left", "right")}}

\item{scales}{A \code{character(1)} or \code{logical(1)} whether scales are shared
across facets or allowed to vary. One of the following:
\describe{
\item{\code{"fixed"} or \code{FALSE}}{Scales are shared across all facets
(default).}
\item{\code{"free_x"}}{x-scales are allowed to vary.}
\item{\code{"free_y"}}{y-scales are allowed to vary.}
\item{\code{"free"} or \code{TRUE}}{Both scales can vary}
}}

\item{axes}{A \code{character(1)} or \code{logical(1)} where axes should be drawn. One
of the following:
\describe{
\item{\code{"margins"} or \code{FALSE}}{Only draw axes at the outer margins
(default).}
\item{\code{"x"}}{Draw axes at the outer margins and all inner x-axes too.}
\item{\code{"y"}}{Draw axes at the outer margins and all inner y-axes too.}
\item{\code{"all"} or \code{TRUE}}{Draw the axes for every panel.}
}}

\item{remove_labels}{A \code{character(1)} or \code{logical(1)} determining whether
axis text is displayed at inner panels. One of the following:
\describe{
\item{\code{"none"} or \code{FALSE}}{Display axis text at all axes (default).}
\item{\code{"x"}}{Display axis text at outer margins and all inner y-axes.}
\item{\code{"y"}}{Display axis text at outer margins and all inner x-axes.}
\item{\code{"all"} or \code{TRUE}}{Only display axis text at the outer margins.}
}}

\item{labeller}{A function that takes one data frame of labels and
returns a list or data frame of character vectors. Each input
column corresponds to one factor. Thus there will be more than
one with \code{vars(cyl, am)}. Each output
column gets displayed as one separate line in the strip
label. This function should inherit from the "labeller" S3 class
for compatibility with \code{\link[ggplot2:labeller]{labeller()}}. You can use different labeling
functions for different kind of labels, for example use \code{\link[ggplot2:label_parsed]{label_parsed()}} for
formatting facet labels. \code{\link[ggplot2:label_value]{label_value()}} is used by default,
check it for more details and pointers to other options.}

\item{trim_blank}{A \code{logical(1)}. When \code{TRUE} (default), the design will
be trimmed to remove empty rows and columns.}

\item{strip}{An object created by a call to a strip function, such as
\code{\link[=strip_vanilla]{strip_vanilla}}.}
}
\value{
A \code{Facet} ggproto object that can be added to a plot.
}
\description{
In \code{facet_manual()} the layout for panels is determined by a custom design.
Inspired by base-R graphics \code{\link[graphics:layout]{layout()}} function, this
variant of facets offers more freedom in how panels are displayed, but
comes with less guarantees that it looks right.
}
\examples{
# A standard plot
p <- ggplot(mtcars, aes(mpg, wt)) +
  geom_point()

# The `design` argument can be a character string.
# New rows are indicated by newline symbol (`\n`), which are added
# automatically for multi-line strings.
# The `#`-symbol indicates empty cells.
design <- "
 A##
 AB#
 #BC
 ##C
"
p + facet_manual(~ cyl, design)

# Alternatively, the `design` argument can be a matrix.
# Using `NA`s will leave the cell empty.
design <- matrix(c(1,2,3,3), 2, 2, byrow = TRUE)
p + facet_manual(~ cyl, design)

# The sizes of columns and rows can be adjusted with the `widths` and
# `heights`parameters respectively.
p + facet_manual(
  ~ cyl, t(design),
  widths = c(2, 1), heights = c(2, 1), respect = TRUE
)
}
\seealso{
Other facetting functions: 
\code{\link{facet_grid2}()},
\code{\link{facet_nested_wrap}()},
\code{\link{facet_nested}()},
\code{\link{facet_wrap2}()}
}
\concept{facetting functions}
