% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MullerPlot.R
\name{add_start_points}
\alias{add_start_points}
\title{Add rows to a population dataframe to ensure genotype starting points are plotted correctly}
\usage{
add_start_points(pop_df)
}
\arguments{
\item{pop_df}{Dataframe with column names "Generation", "Identity" and "Population"}
}
\value{
The input Dataframe with additional rows.
}
\description{
The function 1) identifies the time points at which new genotypes appear;
2) copies all the rows of data for these time points; 3) modifies the copied rows by slighlty decreasing
Generation and setting Population of the emerging genotypes to be close to zero;
and then 4) adds the modified rows to the dataframe. This ensures that ggplot doesn't plot blank spaces
where genotypes first emerge.
}
\examples{
pop1 <- data.frame(Generation = rep(1:5, each = 4), Identity = rep(1:4, 5), 
                   Population = c(1,0,0,0,1,1,0,0,1,1,1,0,1,1,1,1,1,1,1,1))
add_start_points(pop1)

}
\author{
Rob Noble, \email{robjohnnoble@gmail.com}
}
