% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom-serialaxes.R, R/stat-serialaxes.R
\name{geom_serialaxes}
\alias{geom_serialaxes}
\alias{stat_serialaxes}
\alias{stat_dotProduct}
\title{Serial axes layer}
\usage{
geom_serialaxes(
  mapping = NULL,
  data = NULL,
  stat = "serialaxes",
  position = "identity",
  ...,
  axes.sequence = character(0L),
  merge = TRUE,
  na.rm = FALSE,
  orientation = NA,
  show.legend = NA,
  inherit.aes = TRUE
)

stat_serialaxes(
  mapping = NULL,
  data = NULL,
  geom = "serialaxes",
  position = "identity",
  ...,
  axes.sequence = character(0L),
  merge = TRUE,
  axes.position = NULL,
  scaling = c("data", "variable", "observation", "none"),
  na.rm = FALSE,
  orientation = NA,
  show.legend = NA,
  inherit.aes = TRUE
)

stat_dotProduct(
  mapping = NULL,
  data = NULL,
  geom = "path",
  position = "identity",
  ...,
  axes.sequence = character(0L),
  merge = TRUE,
  scaling = c("data", "variable", "observation", "none"),
  transform = andrews,
  na.rm = FALSE,
  orientation = NA,
  show.legend = NA,
  inherit.aes = TRUE
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2:aes]{aes()}}. If specified and
\code{inherit.aes = TRUE} (the default), it is combined with the default mapping
at the top level of the plot. You must supply \code{mapping} if there is no plot
mapping.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[ggplot2:ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[ggplot2:fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame}, and
will be used as the layer data. A \code{function} can be created
from a \code{formula} (e.g. \code{~ head(.x, 10)}).}

\item{stat}{The statistical transformation to use on the data for this
layer, either as a \code{ggproto} \code{Geom} subclass or as a string naming the
stat stripped of the \code{stat_} prefix (e.g. \code{"count"} rather than
\code{"stat_count"})}

\item{position}{Position adjustment, either as a string naming the adjustment
(e.g. \code{"jitter"} to use \code{position_jitter}), or the result of a call to a
position adjustment function. Use the latter if you need to change the
settings of the adjustment.}

\item{...}{Other arguments passed on to \code{\link[ggplot2:layer]{layer()}}. These are
often aesthetics, used to set an aesthetic to a fixed value, like
\code{colour = "red"} or \code{size = 3}. They may also be parameters
to the paired geom/stat.}

\item{axes.sequence}{A vector to define the axes sequence. In serial axes coordinate, the sequence can be either
determined in \code{mapping} (function \code{aes()}) or by \code{axes.sequence}. The only difference is that
the \code{mapping} aesthetics will omit the duplicated axes (check examples in \code{\link{geom_serialaxes}}).}

\item{merge}{Should \code{axes.sequence} be merged with mapping aesthetics
as a single mapping \code{uneval} object?}

\item{na.rm}{If \code{FALSE}, the default, missing values are removed with
a warning. If \code{TRUE}, missing values are silently removed.}

\item{orientation}{The orientation of the layer. The default (\code{NA})
automatically determines the orientation from the aesthetic mapping. In the
rare event that this fails it can be given explicitly by setting \code{orientation}
to either \code{"x"} or \code{"y"}. See the \emph{Orientation} section for more detail.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[ggplot2:borders]{borders()}}.}

\item{geom}{The geometric object to use to display the data, either as a
\code{ggproto} \code{Geom} subclass or as a string naming the geom stripped of the
\code{geom_} prefix (e.g. \code{"point"} rather than \code{"geom_point"})}

\item{axes.position}{A numerical vector to determine the axes sequence position;
the length should be the same with the length of \code{axes.sequence} (or mapping \code{aesthetics}, see examples).}

\item{scaling}{one of \code{data}, \code{variable}, \code{observation} or
\code{none} (not suggested the layout is the same with \code{data})
to specify how the data is scaled.}

\item{transform}{A transformation function, can be either \code{andrews}, \code{legendre} or
some other customized transformation functions.}
}
\description{
Draw a serial axes layer, parallel axes under Cartesian system and radial axes under Polar system.
It only takes the "widens" data. Each non-aesthetics component defined in the mapping \code{aes()} will
be treated as an axis.
}
\details{
The difference between the "lengthens" data and "widens" data can be found in
\href{http://vita.had.co.nz/papers/tidy-data.pdf}{Tidy Data}.
How to transform one to the other is explained in \href{https://tidyr.tidyverse.org/articles/pivot.html}{tidyr}
}
\examples{
# parallel coordinate
p <- ggplot(NBAstats2021,
            mapping = aes(FGA = FGA,
                          `3PA` = `3PA`,
                          FTA = FTA,
                          OFGA = OFGA,
                          O3PA = O3PA,
                          OFTA = OFTA,
                          colour = CONF))

# Teams in West are more likely to make 3-point field goals.
# Besides, they have a better performance in restricting opponents
# to make 3-point field goals.
p +
  geom_serialaxes(scaling = "variable",
                  alpha = 0.4,
                  linewidth = 3) +
  scale_x_continuous(breaks = 1:6,
                     labels = c("FGA", "3PA", "FTA",
                                "OFGA", "O3PA", "OFTA")) +
  scale_y_continuous(labels = NULL)

# andrews plot
p + geom_serialaxes(stat = "dotProduct",
                    scaling = "variable",
                    transform = andrews) # default

# Legendre polynomials
p + geom_serialaxes(stat = "dotProduct",
                    scaling = "variable",
                    transform = legendre)

\donttest{
############# Determine axes sequence
# 1. set the duplicated axes by mapping aesthetics
ggplot(iris, mapping = aes(Sepal.Length = Sepal.Length,
                           Sepal.Width = Sepal.Width,
                           Sepal.Length = Sepal.Length,
                           Sepal.Width = Sepal.Width,
                           colour = Species)) +
  # only two axes, duplicated axes are removed
  geom_serialaxes()

# 2. set the duplicated axes by axes.sequence
ggplot(iris, mapping = aes(colour = Species)) +
  geom_serialaxes(
    axes.sequence = c("Sepal.Length", "Sepal.Width",
                      "Sepal.Length", "Sepal.Width"))
}
}
\seealso{
\code{\link{coord_serialaxes}}, \code{\link{geom_serialaxes_density}},
\code{\link{geom_serialaxes_quantile}}, \code{\link{geom_serialaxes_hist}}

Andrews plot \code{\link{andrews}}, Legendre polynomials \code{\link{legendre}}
}
