% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/a-geom-docs.R, R/geom-rect.R, R/geom-bar.R,
%   R/geom-bin2d.R, R/geom-boxplot.R, R/geom-col.R, R/geom-crossbar.R,
%   R/geom-ribbon.R, R/geom-density.R, R/geom-histogram.R, R/geom-polygon.R,
%   R/geom-map.R, R/geom-sf.R, R/geom-tile.R, R/geom-violin.R
\name{geom-docs}
\alias{geom-docs}
\alias{geom_rect_pattern}
\alias{geom_bar_pattern}
\alias{geom_bin_2d_pattern}
\alias{geom_bin2d_pattern}
\alias{geom_boxplot_pattern}
\alias{geom_col_pattern}
\alias{geom_crossbar_pattern}
\alias{geom_ribbon_pattern}
\alias{geom_area_pattern}
\alias{geom_density_pattern}
\alias{geom_histogram_pattern}
\alias{geom_polygon_pattern}
\alias{geom_map_pattern}
\alias{geom_sf_pattern}
\alias{geom_tile_pattern}
\alias{geom_violin_pattern}
\title{ggplot2 geoms with support for pattern fills}
\usage{
geom_rect_pattern(
  mapping = NULL,
  data = NULL,
  stat = "identity",
  position = "identity",
  ...,
  linejoin = "mitre",
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE
)

geom_bar_pattern(
  mapping = NULL,
  data = NULL,
  stat = "count",
  position = "stack",
  ...,
  just = 0.5,
  width = NULL,
  na.rm = FALSE,
  orientation = NA,
  show.legend = NA,
  inherit.aes = TRUE
)

geom_bin_2d_pattern(
  mapping = NULL,
  data = NULL,
  stat = "bin2d",
  position = "identity",
  ...,
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE
)

geom_bin2d_pattern(
  mapping = NULL,
  data = NULL,
  stat = "bin2d",
  position = "identity",
  ...,
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE
)

geom_boxplot_pattern(
  mapping = NULL,
  data = NULL,
  stat = "boxplot",
  position = "dodge2",
  ...,
  outliers = TRUE,
  outlier.colour = NULL,
  outlier.color = NULL,
  outlier.fill = NULL,
  outlier.shape = 19,
  outlier.size = 1.5,
  outlier.stroke = 0.5,
  outlier.alpha = NULL,
  notch = FALSE,
  notchwidth = 0.5,
  staplewidth = 0,
  varwidth = FALSE,
  na.rm = FALSE,
  orientation = NA,
  show.legend = NA,
  inherit.aes = TRUE
)

geom_col_pattern(
  mapping = NULL,
  data = NULL,
  position = "stack",
  ...,
  just = 0.5,
  width = NULL,
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE
)

geom_crossbar_pattern(
  mapping = NULL,
  data = NULL,
  stat = "identity",
  position = "identity",
  ...,
  fatten = 2.5,
  na.rm = FALSE,
  orientation = NA,
  show.legend = NA,
  inherit.aes = TRUE
)

geom_ribbon_pattern(
  mapping = NULL,
  data = NULL,
  stat = "identity",
  position = "identity",
  ...,
  na.rm = FALSE,
  orientation = NA,
  show.legend = NA,
  inherit.aes = TRUE,
  outline.type = "both"
)

geom_area_pattern(
  mapping = NULL,
  data = NULL,
  stat = "align",
  position = "stack",
  na.rm = FALSE,
  orientation = NA,
  show.legend = NA,
  inherit.aes = TRUE,
  ...,
  outline.type = "upper"
)

geom_density_pattern(
  mapping = NULL,
  data = NULL,
  stat = "density",
  position = "identity",
  ...,
  na.rm = FALSE,
  orientation = NA,
  show.legend = NA,
  inherit.aes = TRUE,
  outline.type = "upper"
)

geom_histogram_pattern(
  mapping = NULL,
  data = NULL,
  stat = "bin",
  position = "stack",
  ...,
  binwidth = NULL,
  bins = NULL,
  na.rm = FALSE,
  orientation = NA,
  show.legend = NA,
  inherit.aes = TRUE
)

geom_polygon_pattern(
  mapping = NULL,
  data = NULL,
  stat = "identity",
  position = "identity",
  rule = "evenodd",
  ...,
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE
)

geom_map_pattern(
  mapping = NULL,
  data = NULL,
  stat = "identity",
  ...,
  map,
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE
)

geom_sf_pattern(
  mapping = aes(),
  data = NULL,
  stat = "sf",
  position = "identity",
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE,
  ...
)

geom_tile_pattern(
  mapping = NULL,
  data = NULL,
  stat = "identity",
  position = "identity",
  ...,
  linejoin = "mitre",
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE
)

geom_violin_pattern(
  mapping = NULL,
  data = NULL,
  stat = "ydensity",
  position = "dodge",
  ...,
  draw_quantiles = NULL,
  trim = TRUE,
  bounds = c(-Inf, Inf),
  scale = "area",
  na.rm = FALSE,
  orientation = NA,
  show.legend = NA,
  inherit.aes = TRUE
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2:aes]{aes()}}. If specified and
\code{inherit.aes = TRUE} (the default), it is combined with the default mapping
at the top level of the plot. You must supply \code{mapping} if there is no plot
mapping.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[ggplot2:ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[ggplot2:fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame}, and
will be used as the layer data. A \code{function} can be created
from a \code{formula} (e.g. \code{~ head(.x, 10)}).}

\item{stat}{The statistical transformation to use on the data for this layer.
When using a \verb{geom_*()} function to construct a layer, the \code{stat}
argument can be used the override the default coupling between geoms and
stats. The \code{stat} argument accepts the following:
\itemize{
\item A \code{Stat} ggproto subclass, for example \code{StatCount}.
\item A string naming the stat. To give the stat as a string, strip the
function name of the \code{stat_} prefix. For example, to use \code{stat_count()},
give the stat as \code{"count"}.
\item For more information and other ways to specify the stat, see the
\link[ggplot2:layer_stats]{layer stat} documentation.
}}

\item{position}{A position adjustment to use on the data for this layer. This
can be used in various ways, including to prevent overplotting and
improving the display. The \code{position} argument accepts the following:
\itemize{
\item The result of calling a position function, such as \code{position_jitter()}.
This method allows for passing extra arguments to the position.
\item A string naming the position adjustment. To give the position as a
string, strip the function name of the \code{position_} prefix. For example,
to use \code{position_jitter()}, give the position as \code{"jitter"}.
\item For more information and other ways to specify the position, see the
\link[ggplot2:layer_positions]{layer position} documentation.
}}

\item{...}{Other arguments passed on to \code{\link[ggplot2:layer]{layer()}}'s \code{params} argument. These
arguments broadly fall into one of 4 categories below. Notably, further
arguments to the \code{position} argument, or aesthetics that are required
can \emph{not} be passed through \code{...}. Unknown arguments that are not part
of the 4 categories below are ignored.
\itemize{
\item Static aesthetics that are not mapped to a scale, but are at a fixed
value and apply to the layer as a whole. For example, \code{colour = "red"}
or \code{linewidth = 3}. The geom's documentation has an \strong{Aesthetics}
section that lists the available options. The 'required' aesthetics
cannot be passed on to the \code{params}. Please note that while passing
unmapped aesthetics as vectors is technically possible, the order and
required length is not guaranteed to be parallel to the input data.
\item When constructing a layer using
a \verb{stat_*()} function, the \code{...} argument can be used to pass on
parameters to the \code{geom} part of the layer. An example of this is
\code{stat_density(geom = "area", outline.type = "both")}. The geom's
documentation lists which parameters it can accept.
\item Inversely, when constructing a layer using a
\verb{geom_*()} function, the \code{...} argument can be used to pass on parameters
to the \code{stat} part of the layer. An example of this is
\code{geom_area(stat = "density", adjust = 0.5)}. The stat's documentation
lists which parameters it can accept.
\item The \code{key_glyph} argument of \code{\link[ggplot2:layer]{layer()}} may also be passed on through
\code{...}. This can be one of the functions described as
\link[ggplot2:draw_key]{key glyphs}, to change the display of the layer in the legend.
}}

\item{linejoin}{Line join style (round, mitre, bevel).}

\item{na.rm}{If \code{FALSE}, the default, missing values are removed with
a warning. If \code{TRUE}, missing values are silently removed.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[ggplot2:borders]{borders()}}.}

\item{just}{Adjustment for column placement. Set to \code{0.5} by default, meaning
that columns will be centered about axis breaks. Set to \code{0} or \code{1} to place
columns to the left/right of axis breaks. Note that this argument may have
unintended behaviour when used with alternative positions, e.g.
\code{position_dodge()}.}

\item{width}{Bar width. By default, set to 90\% of the \code{\link[ggplot2:resolution]{resolution()}} of the
data.}

\item{orientation}{The orientation of the layer. The default (\code{NA})
automatically determines the orientation from the aesthetic mapping. In the
rare event that this fails it can be given explicitly by setting \code{orientation}
to either \code{"x"} or \code{"y"}. See the \emph{Orientation} section for more detail.}

\item{outliers}{Whether to display (\code{TRUE}) or discard (\code{FALSE}) outliers
from the plot. Hiding or discarding outliers can be useful when, for
example, raw data points need to be displayed on top of the boxplot.
By discarding outliers, the axis limits will adapt to the box and whiskers
only, not the full data range. If outliers need to be hidden and the axes
needs to show the full data range, please use \code{outlier.shape = NA} instead.}

\item{outlier.colour, outlier.color, outlier.fill, outlier.shape, outlier.size, outlier.stroke, outlier.alpha}{Default aesthetics for outliers. Set to \code{NULL} to inherit from the
aesthetics used for the box.

In the unlikely event you specify both US and UK spellings of colour, the
US spelling will take precedence.}

\item{notch}{If \code{FALSE} (default) make a standard box plot. If
\code{TRUE}, make a notched box plot. Notches are used to compare groups;
if the notches of two boxes do not overlap, this suggests that the medians
are significantly different.}

\item{notchwidth}{For a notched box plot, width of the notch relative to
the body (defaults to \code{notchwidth = 0.5}).}

\item{staplewidth}{The relative width of staples to the width of the box.
Staples mark the ends of the whiskers with a line.}

\item{varwidth}{If \code{FALSE} (default) make a standard box plot. If
\code{TRUE}, boxes are drawn with widths proportional to the
square-roots of the number of observations in the groups (possibly
weighted, using the \code{weight} aesthetic).}

\item{fatten}{A multiplicative factor used to increase the size of the
middle bar in \code{geom_crossbar()} and the middle point in
\code{geom_pointrange()}.}

\item{outline.type}{Type of the outline of the area; \code{"both"} draws both the
upper and lower lines, \code{"upper"}/\code{"lower"} draws the respective lines only.
\code{"full"} draws a closed polygon around the area.}

\item{binwidth}{The width of the bins. Can be specified as a numeric value
or as a function that calculates width from unscaled x. Here, "unscaled x"
refers to the original x values in the data, before application of any
scale transformation. When specifying a function along with a grouping
structure, the function will be called once per group.
The default is to use the number of bins in \code{bins},
covering the range of the data. You should always override
this value, exploring multiple widths to find the best to illustrate the
stories in your data.

The bin width of a date variable is the number of days in each time; the
bin width of a time variable is the number of seconds.}

\item{bins}{Number of bins. Overridden by \code{binwidth}. Defaults to 30.}

\item{rule}{Either \code{"evenodd"} or \code{"winding"}. If polygons with holes are
being drawn (using the \code{subgroup} aesthetic) this argument defines how the
hole coordinates are interpreted. See the examples in \code{\link[grid:grid.path]{grid::pathGrob()}} for
an explanation.}

\item{map}{Data frame that contains the map coordinates.  This will
typically be created using \code{\link[ggplot2:fortify]{fortify()}} on a spatial object.
It must contain columns \code{x} or \code{long}, \code{y} or
\code{lat}, and \code{region} or \code{id}.}

\item{draw_quantiles}{If \code{not(NULL)} (default), draw horizontal lines
at the given quantiles of the density estimate.}

\item{trim}{If \code{TRUE} (default), trim the tails of the violins
to the range of the data. If \code{FALSE}, don't trim the tails.}

\item{bounds}{Known lower and upper bounds for estimated data. Default
\code{c(-Inf, Inf)} means that there are no (finite) bounds. If any bound is
finite, boundary effect of default density estimation will be corrected by
reflecting tails outside \code{bounds} around their closest edge. Data points
outside of bounds are removed with a warning.}

\item{scale}{if "area" (default), all violins have the same area (before trimming
the tails). If "count", areas are scaled proportionally to the number of
observations. If "width", all violins have the same maximum width.}
}
\value{
A \link[ggplot2:ggplot2-ggproto]{ggplot2::Geom} object.
}
\description{
All geoms in this package are identical to their counterparts in ggplot2 except
that they can be filled with patterns.
}
\section{Pattern Arguments}{


Not all arguments apply to all patterns.

\describe{
\item{\strong{\code{pattern}}}{Pattern name string e.g. 'stripe' (default), 'crosshatch', 'point', 'circle', 'none'}
\item{\strong{\code{pattern_alpha}}}{ Alpha transparency for pattern. default: 1}
\item{\strong{\code{pattern_angle}}}{ Orientation of the pattern in degrees. default: 30}
\item{\strong{\code{pattern_aspect_ratio}}}{ Aspect ratio adjustment. }
\item{\strong{\code{pattern_colour}}}{ Colour used for strokes and points. default: 'black'}
\item{\strong{\code{pattern_density}}}{ Approximate fill fraction of the pattern. Usually in range [0, 1], but can be higher. default: 0.2}
\item{\strong{\code{pattern_filename}}}{ Image filename/URL. }
\item{\strong{\code{pattern_fill}}}{ Fill colour (or \code{\link[grid:patterns]{grid::pattern()}}/gradient fill). default: 'grey80'}
\item{\strong{\code{pattern_fill2}}}{ Second fill colour (or \code{\link[grid:patterns]{grid::pattern()}}/gradient fill). default: '#4169E1'}
\item{\strong{\code{pattern_filter}}}{ (Image scaling) filter. default: 'lanczos' }
\item{\strong{\code{pattern_frequency}}}{ Frequency. default: 0.1 }
\item{\strong{\code{pattern_gravity}}}{ Image placement. default: 'center' }
\item{\strong{\code{pattern_grid}}}{ Pattern grid type. default: 'square' }
\item{\strong{\code{pattern_key_scale_factor}}}{ Scale factor for pattern in legend. default: 1 }
\item{\strong{\code{pattern_linetype}}}{ Stroke linetype. default: 1}
\item{\strong{\code{pattern_option_1}}}{ Generic user value for custom patterns. }
\item{\strong{\code{pattern_option_2}}}{ Generic user value for custom patterns. }
\item{\strong{\code{pattern_option_3}}}{ Generic user value for custom patterns. }
\item{\strong{\code{pattern_option_4}}}{ Generic user value for custom patterns. }
\item{\strong{\code{pattern_option_5}}}{ Generic user value for custom patterns. }
\item{\strong{\code{pattern_orientation}}}{ 'vertical', 'horizontal', or 'radial'. default: 'vertical' }
\item{\strong{\code{pattern_res}}}{ Pattern resolution (pixels per inch). }
\item{\strong{\code{pattern_rot}}}{ Rotation angle (shape within pattern). default: 0 }
\item{\strong{\code{pattern_scale}}}{ Scale. default: 1}
\item{\strong{\code{pattern_shape}}}{ Plotting shape. default: 1}
\item{\strong{\code{pattern_size}}}{ Stroke line width. default: 1}
\item{\strong{\code{pattern_spacing}}}{ Spacing of the pattern as a fraction of the plot size. default: 0.05}
\item{\strong{\code{pattern_type}}}{ Generic control option }
\item{\strong{\code{pattern_subtype}}}{ Generic control option }
\item{\strong{\code{pattern_xoffset}}}{Offset the origin of the pattern. Range [0, 1]. default: 0.  Use this to slightly shift the origin of the pattern. For most patterns, the user should limit the offset value to be less than the pattern spacing.}
\item{\strong{\code{pattern_yoffset}}}{Offset the origin of the pattern. Range [0, 1]. default: 0.  Use this to slightly shift the origin of the pattern. For most patterns, the user should limit the offset value to be less than the pattern spacing.}
}
}

\examples{
  if (require("ggplot2")) {

    # 'stripe' pattern example
    df <- data.frame(level = c("a", "b", "c", 'd'), outcome = c(2.3, 1.9, 3.2, 1))
    gg <- ggplot(df) +
      geom_col_pattern(
        aes(level, outcome, pattern_fill = level),
        pattern = 'stripe',
        fill    = 'white',
        colour  = 'black'
      ) +
      theme_bw(18) +
      theme(legend.position = 'none') +
      labs(
        title    = "ggpattern::geom_col_pattern()",
        subtitle = "pattern = 'stripe'"
      )
    plot(gg)

    # 'pch' pattern example
    gg <- ggplot(mtcars, aes(as.factor(cyl), mpg)) +
      geom_violin_pattern(aes(fill = as.factor(cyl),
                              pattern_shape = as.factor(cyl)),
        pattern = 'pch',
        pattern_density = 0.3,
        pattern_angle = 0,
        colour  = 'black'
      ) +
      theme_bw(18) +
      theme(legend.position = 'none') +
      labs(
        title    = "ggpattern::geom_violin_pattern()",
        subtitle = "pattern = 'pch'"
      )
    plot(gg)

    # 'polygon_tiling' pattern example
    gg <- ggplot(mtcars) +
       geom_density_pattern(
         aes(
           x            = mpg,
           pattern_fill = as.factor(cyl),
           pattern_type = as.factor(cyl)
         ),
         pattern = 'polygon_tiling',
         pattern_key_scale_factor = 1.2
       ) +
       scale_pattern_type_manual(values = c("hexagonal", "rhombille",
                                  "pythagorean")) +
       theme_bw(18) +
       theme(legend.key.size = unit(2, 'cm')) +
       labs(
         title    = "ggpattern::geom_density_pattern()",
         subtitle = "pattern = 'polygon_tiling'"
       )
    plot(gg)
  }

}
