% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggRelatednessMatrix.R
\name{ggRelatednessMatrix}
\alias{ggRelatednessMatrix}
\alias{ggrelatednessmatrix}
\title{Plot a relatedness matrix as a heatmap (ggpedigree style)}
\usage{
ggRelatednessMatrix(
  mat,
  config = list(),
  interactive = FALSE,
  tooltip_cols = NULL,
  ...
)

ggrelatednessmatrix(
  mat,
  config = list(),
  interactive = FALSE,
  tooltip_cols = NULL,
  ...
)
}
\arguments{
\item{mat}{A square numeric matrix of relatedness values (precomputed, e.g., from ped2add).}

\item{config}{A list of graphical and display parameters.
See Details for available options.}

\item{interactive}{Logical; if TRUE, returns an interactive plotly object.}

\item{tooltip_cols}{A character vector of column names to include in tooltips.}

\item{...}{Additional arguments passed to ggplot2 layers.}
}
\value{
A ggplot object displaying the relatedness matrix as a heatmap.
}
\description{
Plots a relatedness matrix using ggplot2 with config options.
}
\details{
Config options include:
 \describe{
  \item{color_palette}{A vector of colors for the heatmap (default: Reds scale)}
  \item{scale_midpoint}{Numeric midpoint for diverging color scale (default: 0.25)}
  \item{title}{Plot title}
  \item{cluster}{Logical; should rows/cols be clustered (default: TRUE)}
  \item{xlab, ylab}{Axis labels}
  \item{text_size}{Axis text size}
}
}
\examples{
# Example relatedness matrix
set.seed(123)
mat <- matrix(runif(100, 0, 1), nrow = 10)
rownames(mat) <- paste0("ID", 1:10)
colnames(mat) <- paste0("ID", 1:10)

# Plot the relatedness matrix
ggRelatednessMatrix(mat,
  config = list(
    color_palette = c("white", "gold", "red"),
    scale_midpoint = 0.5,
    cluster = TRUE,
    title = "Relatedness Matrix",
    xlab = "Individuals",
    ylab = "Individuals",
    text_size = 8
  )
)
}
