% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggpedigree.R
\name{addTwins}
\alias{addTwins}
\title{Add Twins to ggplot Pedigree Plot}
\usage{
addTwins(
  plotObject,
  connections,
  config,
  plot_connections,
  personID = "personID"
)
}
\arguments{
\item{plotObject}{A ggplot object to which twin segments will be added.}

\item{connections}{A data frame containing twin connection coordinates.}

\item{config}{A list of configuration options for customizing the plot.
      See getDefaultPlotConfig for details. The list can include:
\describe{
   \item{code_male}{Integer or string. Value identifying males in the sex column. (typically 0 or 1) Default: 1.}
   \item{segment_spouse_color, segment_self_color}{Character. Line colors for respective connection types.}
   \item{segment_sibling_color, segment_parent_color, segment_offspring_color}{Character. Line colors for respective connection types.}
   \item{label_text_size, point_size, segment_linewidth}{Numeric. Controls text size, point size, and line thickness.}
   \item{generation_height}{Numeric. Vertical spacing multiplier between generations. Default: 1.}
   \item{shape_unknown, shape_female, shape_male, status_shape_affected}{Integers. Shape codes for plotting each group.}
   \item{sex_shape_labels}{Character vector of labels for the sex variable. (default: c("Female", "Male", "Unknown"))}
   \item{unaffected, affected}{Values indicating unaffected/affected status.}
   \item{sex_color_include}{Logical. If TRUE, uses color to differentiate sex.}
   \item{label_max_overlaps}{Maximum number of overlaps allowed in repelled labels.}
   \item{label_segment_color}{Color used for label connector lines.}
 }}

\item{plot_connections}{A data frame containing the coordinates for twin segments.}

\item{personID}{Character string specifying the column name for individual IDs. Defaults to "personID".}
}
\value{
A ggplot object with twin segments added.
}
\description{
Adds twin connections to the ggplot pedigree plot.
This function modifies the `plotObject` by adding segments
to represent twin relationships.
}
\keyword{internal}
