% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aes-calculated.r
\name{stat}
\alias{stat}
\title{Calculated aesthetics}
\usage{
stat(x)
}
\arguments{
\item{x}{An aesthetic expression using variables calculated by the stat.}
}
\description{
Most aesthetics are mapped from variables found in the data. Sometimes,
however, you want to map from variables computed by the aesthetic. The
most common example of this is the height of bars in \code{\link[=geom_histogram]{geom_histogram()}}:
the height does not come from a variable in the underlying data, but
is instead mapped to the \code{count} computed by \code{\link[=stat_bin]{stat_bin()}}. The \code{stat()}
function is a flag to ggplot2 to it that you want to use calculated
aesthetics produced by the statistic.
}
\details{
This replaces the older approach of surrounding the variable name with
\code{..}.
}
\examples{
# Default histogram display
ggplot(mpg, aes(displ)) +
  geom_histogram(aes(y = stat(count)))

# Scale tallest bin to 1
ggplot(mpg, aes(displ)) +
  geom_histogram(aes(y = stat(count / max(count))))
}
