% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/position-dodge.r, R/position-dodge2.r
\name{position_dodge}
\alias{position_dodge}
\alias{position_dodge2}
\title{Dodge overlapping objects side-to-side}
\usage{
position_dodge(width = NULL, preserve = c("total", "single"))

position_dodge2(
  width = NULL,
  preserve = c("total", "single"),
  padding = 0.1,
  reverse = FALSE
)
}
\arguments{
\item{width}{Dodging width, when different to the width of the individual
elements. This is useful when you want to align narrow geoms with wider
geoms. See the examples.}

\item{preserve}{Should dodging preserve the total width of all elements
at a position, or the width of a single element?}

\item{padding}{Padding between elements at the same position. Elements are
shrunk by this proportion to allow space between them. Defaults to 0.1.}

\item{reverse}{If \code{TRUE}, will reverse the default stacking order.
This is useful if you're rotating both the plot and legend.}
}
\description{
Dodging preserves the vertical position of an geom while adjusting the
horizontal position. \code{position_dodge()} requires the grouping variable to be
be specified in the global or \verb{geom_*} layer. Unlike \code{position_dodge()},
\code{position_dodge2()} works without a grouping variable in a layer.
\code{position_dodge2()} works with bars and rectangles, but is
particulary useful for arranging box plots, which
can have variable widths.
}
\examples{
ggplot(mtcars, aes(factor(cyl), fill = factor(vs))) +
  geom_bar(position = "dodge2")

# By default, dodging with `position_dodge2()` preserves the total width of
# the elements. You can choose to preserve the width of each element with:
ggplot(mtcars, aes(factor(cyl), fill = factor(vs))) +
  geom_bar(position = position_dodge2(preserve = "single"))

\donttest{
ggplot(diamonds, aes(price, fill = cut)) +
  geom_histogram(position="dodge2")
# see ?geom_bar for more examples

# In this case a frequency polygon is probably a better choice
ggplot(diamonds, aes(price, colour = cut)) +
  geom_freqpoly()
}

# Dodging with various widths -------------------------------------
# To dodge items with different widths, you need to be explicit
df <- data.frame(x = c("a","a","b","b"), y = 2:5, g = rep(1:2, 2))
p <- ggplot(df, aes(x, y, group = g)) +
  geom_col(position = "dodge", fill = "grey50", colour = "black")
p

# A line range has no width:
p + geom_linerange(aes(ymin = y - 1, ymax = y + 1), position = "dodge")

# So you must explicitly specify the width
p + geom_linerange(
  aes(ymin = y - 1, ymax = y + 1),
  position = position_dodge(width = 0.9)
)

# The same principle applies to error bars, which are usually
# narrower than the bars
p + geom_errorbar(
  aes(ymin = y - 1, ymax = y + 1),
  width = 0.2,
  position = "dodge"
)
p + geom_errorbar(
  aes(ymin = y - 1, ymax = y + 1),
  width = 0.2,
  position = position_dodge(width = 0.9)
)

# Box plots use position_dodge2 by default, and bars can use it too
ggplot(data = iris, aes(Species, Sepal.Length)) +
  geom_boxplot(aes(colour = Sepal.Width < 3.2))

ggplot(data = iris, aes(Species, Sepal.Length)) +
  geom_boxplot(aes(colour = Sepal.Width < 3.2), varwidth = TRUE)

ggplot(mtcars, aes(factor(cyl), fill = factor(vs))) +
  geom_bar(position = position_dodge2(preserve = "single"))

ggplot(mtcars, aes(factor(cyl), fill = factor(vs))) +
  geom_bar(position = position_dodge2(preserve = "total"))
}
\seealso{
Other position adjustments: 
\code{\link{position_identity}()},
\code{\link{position_jitterdodge}()},
\code{\link{position_jitter}()},
\code{\link{position_nudge}()},
\code{\link{position_stack}()}
}
\concept{position adjustments}
