% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/position-stacknudge-to.R
\name{position_stacknudge_to}
\alias{position_stacknudge_to}
\alias{position_fillnudge_to}
\title{Stack plus nudge labels to new positions}
\usage{
position_stacknudge_to(
  vjust = 1,
  reverse = FALSE,
  x = NULL,
  y = NULL,
  x.action = c("none", "spread"),
  y.action = c("none", "spread"),
  x.distance = "equal",
  y.distance = "equal",
  x.expansion = 0,
  y.expansion = 0,
  kept.origin = c("stacked", "original", "none")
)

position_fillnudge_to(
  vjust = 1,
  reverse = FALSE,
  x = NULL,
  y = NULL,
  x.action = c("none", "spread"),
  y.action = c("none", "spread"),
  x.distance = "equal",
  y.distance = "equal",
  x.expansion = 0,
  y.expansion = 0,
  kept.origin = c("stacked", "original", "none")
)
}
\arguments{
\item{vjust}{Vertical adjustment for geoms that have a position (like points
or lines), not a dimension (like bars or areas). Set to 0 to align with the
bottom, 0.5 for the middle, and 1 (the default) for the top.}

\item{reverse}{If TRUE, will reverse the default stacking order. This is
useful if you're rotating both the plot and legend.}

\item{x, y}{Coordinates of the destination position. A vector of mode
\code{numeric}, that is extended if needed, to the same length as rows
there are in \code{data}. The default, \code{NULL}, leaves the original
coordinates unchanged after dodging.}

\item{x.action, y.action}{character string, one of \code{"none"}, or
\code{"spread"}. With \code{"spread"} distributing the positions
within the range of argument \code{x} or \code{y}, if non-null, or the
range the variable mapped to \emph{x} or \code{y}, otherwise.}

\item{x.distance, y.distance}{character or numeric Currently only
\code{"equal"} is implemented.}

\item{x.expansion, y.expansion}{numeric vectors of length 1 or 2, as a
fraction of width of the range.}

\item{kept.origin}{One of \code{"original"}, \code{"stacked"} or
\code{"none"}.}
}
\value{
A \code{"Position"} object.
}
\description{
Functions \code{position_stacknudge_to()} and \code{position_fillnudge_to()}
are meant to complement \code{position_stack()} and \code{position_fill()}
from 'ggplot2', adding as a second action that of \code{position_nudge_to()}.
These positions are generally useful for adjusting the position of labels or
text. As with other position functions in this package, the original
positions are preserved to allow the text or labels to be linked back to
their original position with a segment or arrow.
}
\details{
These positions apply sequentially two actions, in the order they
  appear in their names. The applied stacking is similar to that by
  \code{\link[ggplot2]{position_stack}} and
  \code{\link[ggplot2]{position_fill}} while nudging is different to that
  by \code{\link[ggplot2]{position_nudge}} and equal to that applied by
  \code{\link{position_nudge_to}}.

  The nudged to \code{x} and/or \code{y} values replace the original
  ones in \code{data}, while the original or the stacked coordinates are
  returned in \code{x_orig} and \code{y_orig}. Nudge values supported are
  those of \emph{mode} numeric, thus including dates and times when they
  match the mapped data.

  If the length of \code{x} and/or \code{y} is more than one but less than
  rows are present in the data, the vector is both recycled and reordered so
  that the nudges are applied sequentially based on the data values. If their
  length matches the number of rows in data, they are assumed to be already
  in data order.

  When applying stacking, the return of original positions instead of the
  stacked ones is achieved by passing \code{origin = "original"} instead of
  the default of \code{origin = "stacked"}.
}
\note{
Irrespective of the action, the ordering of rows in \code{data} is
  preserved.
}
\examples{

cols.df <- data.frame(x1 = c(1, 2, 1, 3),
                       x2 = c("a", "a", "b", "b"),
                       grp = c("A", "B", "C", "D"))

 ggplot(data = cols.df, aes(x2, x1, group = grp)) +
 geom_col(aes(fill = grp), width=0.5, position = "stack") +
   geom_vline(xintercept = 0) +
   geom_text_s(
     aes(label = x1),
     position = position_stacknudge_to(x = c(1.4, 1.4, 1.6, 1.6))) +
   theme(legend.position = "none")

 ggplot(data = cols.df, aes(x2, x1, group = grp)) +
 geom_col(aes(fill = grp), width=0.5, position = "fill") +
   geom_vline(xintercept = 0) +
   geom_text_s(
     aes(label = grp),
     position = position_fillnudge_to(x = c(1.4, 1.4, 1.6, 1.6))) +
   theme(legend.position = "none")

 ggplot(data = cols.df, aes(x2, x1, group = grp)) +
 geom_col(aes(fill = grp), width=0.5, position = "fill") +
   geom_vline(xintercept = 0) +
   geom_text_s(
     aes(label = x1),
     position = position_fillnudge_to(vjust = 0.5,
                                      x = c(1.4, 1.4, 1.6, 1.6))) +
   theme(legend.position = "none")

 ggplot(data = cols.df, aes(x2, x1, group = grp)) +
 geom_col(aes(fill = grp), width=0.5, position = "fill") +
   geom_vline(xintercept = 0) +
   geom_text_s(
     aes(label = x1), vjust = 0.5,
     position = position_fillnudge_to(vjust = 0.5,
                                      x = c(1.4, 1.4, 1.6, 1.6),
                                      y = c(0.85, 0.35, 0.85, 0.35))) +
   theme(legend.position = "none")

}
\seealso{
\code{\link{position_nudge_to}},
  \code{\link[ggplot2]{position_stack}}.

Other position adjustments: 
\code{\link{position_dodgenudge}()},
\code{\link{position_dodgenudge_to}()},
\code{\link{position_jitternudge}()},
\code{\link{position_nudge_center}()},
\code{\link{position_nudge_keep}()},
\code{\link{position_nudge_line}()},
\code{\link{position_nudge_to}()},
\code{\link{position_stacknudge}()}
}
\concept{position adjustments}
