% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat_pvalue_manual.R
\name{stat_pvalue_manual}
\alias{stat_pvalue_manual}
\title{Add Manually P-values to a ggplot}
\usage{
stat_pvalue_manual(
  data,
  label = NULL,
  y.position = "y.position",
  xmin = "group1",
  xmax = "group2",
  x = NULL,
  size = 3.88,
  label.size = size,
  bracket.size = 0.3,
  bracket.nudge.y = 0,
  bracket.shorten = 0,
  color = "black",
  linetype = 1,
  tip.length = 0.03,
  remove.bracket = FALSE,
  step.increase = 0,
  step.group.by = NULL,
  hide.ns = FALSE,
  vjust = 0,
  coord.flip = FALSE,
  position = "identity",
  ...
)
}
\arguments{
\item{data}{a data frame containing statitistical test results. The expected
default format should contain the following columns: \code{group1 | group2 |
p | y.position | etc}. \code{group1} and \code{group2} are the groups that
have been compared. \code{p} is the resulting p-value. \code{y.position} is
the y coordinates of the p-values in the plot.}

\item{label}{the column containing the label (e.g.: label = "p" or label =
"p.adj"), where \code{p} is the p-value. Can be also an expression that can
be formatted by the \code{\link[glue]{glue}()} package. For example, when
specifying label = "t-test, p = \{p\}", the expression \{p\} will be
replaced by its value.}

\item{y.position}{column containing the coordinates (in data units) to be used
for absolute positioning of the label. Default value is "y.position". Can be
also a numeric vector.}

\item{xmin}{column containing the position of the left sides of the brackets.
Default value is "group1".}

\item{xmax}{(optional) column containing the position of the right sides of
the brackets. Default value is "group2". If NULL, the p-values are plotted
as a simple text.}

\item{x}{x position of the p-value. Should be used only when you want plot the
p-value as text (without brackets).}

\item{size, label.size}{size of label text.}

\item{bracket.size}{Width of the lines of the bracket.}

\item{bracket.nudge.y}{Vertical adjustment to nudge brackets by. Useful to
move up or move down the bracket. If positive value, brackets will be moved
up; if negative value, brackets are moved down.}

\item{bracket.shorten}{a small numeric value in [0-1] for shortening the with
of bracket.}

\item{color}{text and line color. Can be variable name in the data for coloring by groups.}

\item{linetype}{linetype. Can be variable name in the data for changing linetype by groups.}

\item{tip.length}{numeric vector with the fraction of total height that the
bar goes down to indicate the precise column. Default is 0.03.}

\item{remove.bracket}{logical, if \code{TRUE}, brackets are removed from the
plot. Considered only in the situation, where comparisons are performed
against reference group or against "all".}

\item{step.increase}{numeric vector with the increase in fraction of total
height for every additional comparison to minimize overlap.}

\item{step.group.by}{a variable name for grouping brackets before adding
step.increase. Useful to group bracket by facet panel.}

\item{hide.ns}{can be logical value or a character vector.
\itemize{
\item Case when logical value. If TRUE, hide ns symbol when displaying
 significance levels. Filter is done by checking the column
 \code{p.adj.signif}, \code{p.signif}, \code{p.adj} and \code{p}.
 \item Case when character value. Possible values are "p" or "p.adj", for filtering out non significant.
 }}

\item{vjust}{move the text up or down relative to the bracket. Can be also a
column name available in the data.}

\item{coord.flip}{logical. If \code{TRUE}, flip x and y coordinates so that
horizontal becomes vertical, and vertical, horizontal. When adding the
p-values to a horizontal ggplot (generated using
\code{\link[ggplot2]{coord_flip}()}), you need to specify the option
\code{coord.flip = TRUE}.}

\item{position}{position adjustment, either as a string, or the result of a
call to a position adjustment function.}

\item{...}{other arguments passed to the function \code{geom_bracket()} or
\code{geom_text()}}
}
\description{
Add manually p-values to a ggplot, such as box blots, dot plots
 and stripcharts. Frequently asked questions are available on \href{https://www.datanovia.com/en/blog/tag/ggpubr/}{Datanovia ggpubr FAQ page}, for example:
 \itemize{
 \item \href{https://www.datanovia.com/en/blog/how-to-add-p-values-onto-basic-ggplots/}{How to Add P-Values onto Basic GGPLOTS}
 \item \href{https://www.datanovia.com/en/blog/ggpubr-how-to-add-adjusted-p-values-to-a-multi-panel-ggplot/}{How to Add Adjusted P-values to a Multi-Panel GGPlot}
 \item \href{https://www.datanovia.com/en/blog/how-to-add-p-values-to-ggplot-facets/}{How to Add P-values to GGPLOT Facets}
 \item \href{https://www.datanovia.com/en/blog/ggpubr-how-to-add-p-values-generated-elsewhere-to-a-ggplot/}{How to Add P-Values Generated Elsewhere to a GGPLOT}
 \item \href{https://www.datanovia.com/en/blog/how-to-add-p-values-onto-a-grouped-ggplot-using-the-ggpubr-r-package/}{How to Add P-Values onto a Grouped GGPLOT using the GGPUBR R Package}
 \item \href{https://www.datanovia.com/en/blog/how-to-create-stacked-bar-plots-with-error-bars-and-p-values/}{How to Create Stacked Bar Plots with Error Bars and P-values}
 \item \href{https://www.datanovia.com/en/blog/how-to-add-p-values-onto-horizontal-ggplots/}{How to Add P-Values onto Horizontal GGPLOTS}
 }
}
\examples{

# T-test
stat.test <- compare_means(
 len ~ dose, data = ToothGrowth,
 method = "t.test"
)
stat.test

# Create a simple box plot
p <- ggboxplot(ToothGrowth, x = "dose", y = "len")
p

# Perform a t-test between groups
stat.test <- compare_means(
 len ~ dose, data = ToothGrowth,
 method = "t.test"
)
stat.test

# Add manually p-values from stat.test data
# First specify the y.position of each comparison
stat.test <- stat.test \%>\%
 mutate(y.position = c(29, 35, 39))
p + stat_pvalue_manual(stat.test, label = "p.adj")

# Customize the label with glue expression
# (https://github.com/tidyverse/glue)
p + stat_pvalue_manual(stat.test, label = "p = {p.adj}")


# Grouped bar plots
#\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%
ToothGrowth$dose <- as.factor(ToothGrowth$dose)
# Comparisons against reference
stat.test <- compare_means(
  len ~ dose, data = ToothGrowth, group.by = "supp",
  method = "t.test", ref.group = "0.5"
)
stat.test
# Plot
bp <- ggbarplot(ToothGrowth, x = "supp", y = "len",
                fill = "dose", palette = "jco",
                add = "mean_sd", add.params = list(group = "dose"),
                position = position_dodge(0.8))
bp + stat_pvalue_manual(
  stat.test, x = "supp", y.position = 33,
  label = "p.signif",
  position = position_dodge(0.8)
)

}
\seealso{
\code{\link{stat_compare_means}}
}
