% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggkm.R
\docType{data}
\name{GeomKmticks}
\alias{GeomKmticks}
\alias{geom_kmticks}
\title{Display tick marks on a Kaplan Meier curve}
\format{An object of class \code{GeomKmticks} (inherits from \code{Geom}, \code{ggproto}, \code{gg}) of length 6.}
\usage{
GeomKmticks

geom_kmticks(mapping = NULL, data = NULL, stat = "kmticks",
  position = "identity", show.legend = NA, inherit.aes = TRUE,
  na.rm = TRUE, ...)
}
\description{
Ticks are plotted at censoring times that are also not event times

Adds tickmarks at the times when there are censored observations but no events
}
\section{Aesthetics}{

\code{geom_kmticks} understands the following aesthetics (required aesthetics
are in bold):
\itemize{
  \item \strong{\code{x}} The survival/censoring times. This is automatically mapped by \link{stat_km}
  \item \strong{\code{y}} The survival probability estimates. This is automatically mapped by \link{stat_km}
  smallest level in sort order is assumed to be 0, with a warning
  \item \code{alpha}
  \item \code{color}
  \item \code{linetype}
  \item \code{size}
}
}

\examples{
library(ggplot2)
sex <- rbinom(250, 1, .5)
df <- data.frame(time = exp(rnorm(250, mean = sex)), status = rbinom(250, 1, .75), sex = sex)
ggplot(df, aes(time = time, status = status, color = factor(sex))) + geom_km() + geom_kmticks()
}
\seealso{
The default stat for this geom is \code{\link{stat_kmticks}} see
  that documentation for more options to control the underlying statistical transformation.
}
\keyword{internal}
