% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rasterise.R
\name{rasterise}
\alias{rasterise}
\alias{rasterize}
\title{Rasterise ggplot layers
Takes a ggplot layer as input and renders their graphical output as a raster.}
\usage{
rasterise(layer, dpi = NULL, dev = "cairo")

rasterize(layer, dpi = NULL, dev = "cairo")
}
\arguments{
\item{layer}{A \code{Layer} object, typically constructed with a call to a
\code{geom_*()} or \code{stat_*()} function.}

\item{dpi}{An integer of length one setting the desired resolution in dots per inch. (default=NULL)}

\item{dev}{A character specifying a device. Can be one of: \code{"cairo"}, \code{"ragg"} or \code{"ragg_png"}. (default="cairo")}
}
\value{
A modified \code{Layer} object.
}
\description{
Rasterise ggplot layers
Takes a ggplot layer as input and renders their graphical output as a raster.
}
\examples{
require(ggplot2)
# `rasterise()` is used to wrap layers
ggplot(pressure, aes(temperature, pressure)) +
  rasterise(geom_line())

# The `dpi` argument controls resolution
ggplot(faithful, aes(eruptions, waiting)) +
  rasterise(geom_point(), dpi = 5)

# The `dev` argument offers a few options for devices
require(ragg)
ggplot(diamonds, aes(carat, depth, z = price)) +
  rasterise(stat_summary_hex(), dev = "ragg")

}
\author{
Teun van den Brand <t.vd.brand@nki.nl>
}
