% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat-wb-label.R
\name{stat_wb_label}
\alias{stat_wb_label}
\title{Label ranges under spectral curve.}
\usage{
stat_wb_label(
  mapping = NULL,
  data = NULL,
  geom = "text",
  position = "identity",
  ...,
  w.band = NULL,
  chroma.type = "CMF",
  label.fmt = "\%s",
  ypos.fixed = 0,
  na.rm = TRUE,
  show.legend = NA,
  inherit.aes = TRUE
)
}
\arguments{
\item{mapping}{The aesthetic mapping, usually constructed with
\code{\link[ggplot2]{aes}} or \code{\link[ggplot2]{aes_}}. Only needs
to be set at the layer level if you are overriding the plot defaults.}

\item{data}{A layer specific dataset - only needed if you want to override
the plot defaults.}

\item{geom}{The geometric object to use display the data}

\item{position}{The position adjustment to use for overlapping points on this
layer}

\item{...}{other arguments passed on to \code{\link[ggplot2]{layer}}. This
can include aesthetics whose values you want to set, not map. See
\code{\link[ggplot2]{layer}} for more details.}

\item{w.band}{a waveband object or a list of waveband objects or numeric
vector of at least length two.}

\item{chroma.type}{character one of "CMF" (color matching function) or "CC"
(color coordinates) or a \code{\link[photobiology]{chroma_spct}} object.}

\item{label.fmt}{character string giving a format definition for formating
the name of the waveband.
\code{\link{sprintf}}.}

\item{ypos.fixed}{numeric If not \code{NULL} used a constant value returned
in \code{y}.}

\item{na.rm}{a logical value indicating whether NA values should be stripped
before the computation proceeds.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped. \code{FALSE}
never includes, and \code{TRUE} always includes.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics, rather
than combining with them. This is most useful for helper functions that
define both data and aesthetics and shouldn't inherit behaviour from the
default plot specification, e.g. \code{\link[ggplot2]{borders}}.}
}
\value{
A data frame with one row for each waveband object in the argument
to \code{w.band}. Wavebeand outside the range of the spectral data are
trimmed or discarded.
}
\description{
\code{stat_wb_label} computes the center of a waveband. Sets suitable default
aesthetics for "text" and "label" geoms displaying "boundaries" and "names"
of wavebands. \strong{\code{x}-scale transformations and axis flipping are
currently not supported}.
}
\note{
This stat uses a panel function and ignores grouping as it is meant to
  be used for annotations.
}
\section{Computed variables}{

\describe{
  \item{x}{w.band-midpoint}
  \item{wb.xmin}{w.band minimum}
  \item{wb.xmax}{w.band maximum}
  \item{y}{ypos.fixed or zero}
  \item{wb.color}{color of the w.band}
  \item{wb.name}{label of w.band}
  \item{wb.label}{formatted wb.name}
}
}

\section{Default aesthetics}{

Set by the statistic and available to geoms.
\describe{
  \item{label}{..wb.label..}
  \item{x}{..x..}
  \item{xmin}{..wb.xmin..}
  \item{xmax}{..wb.xmax..}
  \item{fill}{..wb.color..}
}
}

\section{Required aesthetics}{

Required by the statistic and need to be set with \code{aes()}.
\describe{
  \item{x}{numeric, wavelength in nanometres}
}
}

\examples{

library(photobiologyWavebands)
# ggplot() methods for spectral objects set a default mapping for x and y.
ggplot(sun.spct) +
  geom_line() +
  stat_wb_box(w.band = VIS(), ymin = -0.04, ymax = 0,
  color = "black", fill = "white") +
  stat_wb_label(w.band = VIS(), ypos.fixed = -0.02, color = "black")

ggplot(sun.spct) +
  geom_line() +
  stat_wb_hbar(w.band = PAR(), ypos.fixed = 0, size = 1) +
  stat_wb_label(aes(color = ..wb.color..),
                w.band = PAR(), ypos.fixed = +0.025) +
  scale_color_identity()

}
\seealso{
Other stats functions: 
\code{\link{stat_color}()},
\code{\link{stat_find_qtys}()},
\code{\link{stat_find_wls}()},
\code{\link{stat_label_peaks}()},
\code{\link{stat_peaks}()},
\code{\link{stat_spikes}()},
\code{\link{stat_wb_box}()},
\code{\link{stat_wb_column}()},
\code{\link{stat_wb_contribution}()},
\code{\link{stat_wb_hbar}()},
\code{\link{stat_wb_irrad}()},
\code{\link{stat_wb_mean}()},
\code{\link{stat_wb_relative}()},
\code{\link{stat_wb_sirrad}()},
\code{\link{stat_wb_total}()},
\code{\link{stat_wl_strip}()},
\code{\link{stat_wl_summary}()}
}
\concept{stats functions}
