% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/axis-utils-source-spct.R
\name{s.e.irrad_label}
\alias{s.e.irrad_label}
\alias{s.q.irrad_label}
\title{Spectral irradiance axis labels}
\usage{
s.e.irrad_label(
  unit.exponent = NULL,
  markup.format = getOption("photobiology.math", default = "R.expression"),
  time.unit = "second",
  label.text = NULL,
  pc.out = FALSE,
  scaled = FALSE,
  normalised = FALSE,
  normalized = normalised,
  axis.symbols = getOption("ggspectra.axis.symbols", default = TRUE)
)

s.q.irrad_label(
  unit.exponent = NULL,
  markup.format = getOption("photobiology.math", default = "R.expression"),
  time.unit = "second",
  label.text = NULL,
  pc.out = FALSE,
  scaled = FALSE,
  normalised = FALSE,
  normalized = normalised,
  axis.symbols = getOption("ggspectra.axis.symbols", default = TRUE)
)
}
\arguments{
\item{unit.exponent}{integer. The default is guessed from \code{time.unit},
\code{scaled} and \code{normalized}.}

\item{markup.format}{character string, "R", "R.expresion", "r.character", or
"LaTeX".}

\item{time.unit}{character or duration The length of time used as base of
expression.}

\item{label.text}{character Textual portion of the labels.}

\item{pc.out}{logical Flag to enable display of normalised data as
percentages.}

\item{scaled}{logical If \code{TRUE} relative units are assumed.}

\item{normalized, normalised}{logical (\code{FALSE}) or numeric Normalization wavelength
in manometers (nm).}

\item{axis.symbols}{logical If \code{TRUE} symbols of the quantities are
added to the \code{name}. Supported only by \code{format = "R.expression"}.}
}
\value{
a character string or an R expression.
}
\description{
Generate axis labels for spectral irradiance, fluence or exposure in SI units,
using SI scale factors. Output can be selected as character, expression (R
default devices) or LaTeX (for tikz device).
}
\examples{

str(s.e.irrad_label())
str(s.e.irrad_label(axis.symbols = FALSE))
str(s.e.irrad_label(markup.format = "R.expression"))
str(s.e.irrad_label(markup.format = "LaTeX"))
str(s.e.irrad_label(markup.format = "R.character"))

str(s.q.irrad_label())
str(s.q.irrad_label(axis.symbols = FALSE))
str(s.q.irrad_label(markup.format = "R.expression"))
str(s.q.irrad_label(markup.format = "LaTeX"))
str(s.q.irrad_label(markup.format = "R.character"))

}
