% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoplot-filter-spct.r
\name{autoplot.object_spct}
\alias{autoplot.object_spct}
\alias{autoplot.object_mspct}
\title{Create a complete ggplot for a object spectrum.}
\usage{
\method{autoplot}{object_spct}(object, ...,
  w.band = getOption("photobiology.plot.bands", default = list(UVC(),
  UVB(), UVA(), PAR())), range = NULL, plot.qty = "all",
  pc.out = FALSE, label.qty = NULL, span = 61, annotations = NULL,
  time.format = "", tz = "UTC", stacked = TRUE, text.size = 2.5,
  idfactor = NULL, ylim = c(NA, NA),
  object.label = deparse(substitute(object)), na.rm = TRUE)

\method{autoplot}{object_mspct}(object, ..., range = NULL)
}
\arguments{
\item{object}{an object_spct object}

\item{...}{in the case of collections of spectra, additional arguments passed
to the plot methods for individual spectra, otherwise currently ignored.}

\item{w.band}{a single waveband object or a list of waveband objects}

\item{range}{an R object on which range() returns a vector of length 2, with
min annd max wavelengths (nm)}

\item{plot.qty}{character string, one of "all", "transmittance",
"absorbance", "absorptance", or "reflectance".}

\item{pc.out}{logical, if TRUE use percents instead of fraction of one}

\item{label.qty}{character string giving the type of summary quantity to use
for labels, one of "mean", "total", "contribution", and "relative".}

\item{span}{a peak is defined as an element in a sequence which is greater
than all other elements within a window of width span centered at that
element.}

\item{annotations}{a character vector}

\item{time.format}{character Format as accepted by \code{\link[base]{strptime}}.}

\item{tz}{character Time zone to use for title and/or subtitle.}

\item{stacked}{logical}

\item{text.size}{numeric size of text in the plot decorations.}

\item{idfactor}{character Name of an index column in data holding a
\code{factor} with each spectrum in a long-form multispectrum object
corresponding to a distinct spectrum. If \code{idfactor=NULL} the name of
the factor is retrieved from metadata or if no metadata found, the
default "spct.idx" is tried. If \code{idfactor=NA} no aesthetic is mapped
to the spectra and the user needs to use 'ggplot2' functions to manually
map an aesthetic or use facets for the spectra.}

\item{ylim}{numeric y axis limits,}

\item{object.label}{character The name of the object being plotted.}

\item{na.rm}{logical.}
}
\value{
a \code{ggplot} object.
}
\description{
This function returns a ggplot object with an annotated plot of an
object_spct object.
}
\note{
The ggplot object returned can be further manipulated and added to.
  Except when no annotations are added, limits are set for the x-axis and
  y-axis scales. The y scale limits are expanded to include all data, or at
  least to the range of expected values. Scales are further expanded so
  as to make space for the annotations. When all \code{"all"} quantities are
  plotted, a single set of spectra is accepted as input.
}
\examples{

autoplot(Ler_leaf.spct)

}
\seealso{
Other autoplot methods: \code{\link{autoplot.calibration_spct}},
  \code{\link{autoplot.cps_spct}},
  \code{\link{autoplot.filter_spct}},
  \code{\link{autoplot.raw_spct}},
  \code{\link{autoplot.reflector_spct}},
  \code{\link{autoplot.response_spct}},
  \code{\link{autoplot.source_spct}},
  \code{\link{autoplot.waveband}}
}
\concept{autoplot methods}
\keyword{hplot}
