% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/decoration.R
\name{set_annotations_default}
\alias{set_annotations_default}
\alias{set_w.band_default}
\title{Set defaults for autoplot annotations}
\usage{
set_annotations_default(annotations = NULL)

set_w.band_default(w.band = NULL)
}
\arguments{
\item{annotations}{character vector Annotations to add or remove from
defaults used by the \code{autoplot()} methods defined in this package..}

\item{w.band}{a single waveband object or a list of waveband objects.}
}
\value{
Previous value of option "photobiology.plot.annotations" returned
  invisibly.
}
\description{
Set R options used when plotting spectra. Option
  "photobiology.plot.annotations" is used as default argument to formal
  parameter \code{annotations} and option "photobiology.plot.bands" is used
  as default argument to formal parameter \code{w.band} in all the
  \code{autoplot()} methods exported from package 'ggspectra'. These
  convenience functions makes it easier to edit these two option which are
  stored as a vector of characters strings and a list of waveband objects,
  respectively.
}
\details{
Vectors of character strings passed as argument to
  \code{annotations} are parsed so that if the first member string is
  \code{"+"}, the remaining members are added to the current default for
  annotations; if it is \code{"-"} the remaining members are removed from the
  current default for annotations; and if it is \code{"="} the remaining
  members become the new default. If the first member is none of these three
  strings, the whole vector becomes the new default. If \code{annotations} is
  \code{NULL} the annotations are reset to the package defaults. When
  removing annotations \code{"title*"}, \code{"peaks*"} and \code{"valleys*"}
  will remove any variation of these annotations. The string \code{""} means
  no annotations while \code{"reserve.space"} means no annotations but expand
  y scale to reserve space for annotations. These two values take precedence
  over any other values in the character vector. The order of the names of
  annotations has no meaning: the vector is interpreted as a set except for
  the three possible "operators" at position 1.
}
\note{
The syntax used and behaviour are the same as for the
  \code{annotations} parameter of the \code{autoplot()} methods for spectra,
  but instead of affecting a single plot, \code{set_annotations_default()}
  changes the default used for subsequent calls to \code{autoplot()}.
}
\seealso{
Other autoplot methods: 
\code{\link{autoplot.calibration_spct}()},
\code{\link{autoplot.cps_spct}()},
\code{\link{autoplot.filter_spct}()},
\code{\link{autoplot.object_spct}()},
\code{\link{autoplot.raw_spct}()},
\code{\link{autoplot.reflector_spct}()},
\code{\link{autoplot.response_spct}()},
\code{\link{autoplot.source_spct}()},
\code{\link{autoplot.waveband}()}
}
\concept{autoplot methods}
