% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers_ggbetween_t_subtitles.R
\name{subtitle_t_parametric}
\alias{subtitle_t_parametric}
\title{Making text subtitle for the t-test (between-/within-subjects
designs).}
\usage{
subtitle_t_parametric(data, x, y, paired = FALSE, effsize.type = "g",
  effsize.noncentral = FALSE, conf.level = 0.95, var.equal = FALSE,
  k = 2, ...)
}
\arguments{
\item{data}{Dataframe from which variables specified are preferentially to be
taken.}

\item{x}{The grouping variable.}

\item{y}{The response - a vector of length the number of rows of \code{x}.}

\item{paired}{a logical indicating whether you want a paired
    t-test.}

\item{effsize.type}{Type of effect size needed for \emph{parametric} tests. The
argument can be \code{"biased"} (\code{"d"} for Cohen's \emph{d} for \strong{t-test};
\code{"partial_eta"} for partial eta-squared for \strong{anova}) or \code{"unbiased"}
(\code{"g"} Hedge's \emph{g} for \strong{t-test}; \code{"partial_omega"} for partial
omega-squared for \strong{anova})).}

\item{effsize.noncentral}{Logical indicating whether to use non-central
\emph{t}-distributions for computing the confidence interval for Cohen's \emph{d}
or Hedge's \emph{g} (Default: \code{FALSE}).}

\item{conf.level}{A scalar value between 0 and 1. If unspecified, the
default is to return \code{95\%} lower and upper confidence intervals (\code{0.95}).}

\item{var.equal}{a logical variable indicating whether to treat the
    variances in the samples as equal.  If \code{TRUE}, then a simple F
    test for the equality of means in a one-way analysis of variance is
    performed.  If \code{FALSE}, an approximate method of Welch (1951)
    is used, which generalizes the commonly known 2-sample Welch test to
    the case of arbitrarily many samples.}

\item{k}{Number of digits after decimal point (should be an integer)
(Default: \code{k = 2}).}

\item{...}{Additional arguments (ignored).}
}
\description{
Making text subtitle for the t-test (between-/within-subjects
designs).
}
\examples{

# creating a smaller dataset
msleep_short <- dplyr::filter(
  .data = ggplot2::msleep,
  vore \%in\% c("carni", "herbi")
)

# with defaults
subtitle_t_parametric(
  data = msleep_short,
  x = vore,
  y = sleep_rem
)

# changing defaults
subtitle_t_parametric(
  data = msleep_short,
  x = vore,
  y = sleep_rem,
  var.equal = TRUE,
  k = 2,
  effsize.type = "d"
)
}
\author{
Indrajeet Patil
}
