% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggdotplotstats.R
\name{ggdotplotstats}
\alias{ggdotplotstats}
\title{Dot plot/chart for labeled numeric data.}
\usage{
ggdotplotstats(
  data,
  x,
  y,
  xlab = NULL,
  ylab = NULL,
  title = NULL,
  subtitle = NULL,
  caption = NULL,
  type = "parametric",
  test.value = 0,
  bf.prior = 0.707,
  bf.message = TRUE,
  effsize.type = "g",
  conf.level = 0.95,
  tr = 0.2,
  digits = 2L,
  results.subtitle = TRUE,
  point.args = list(color = "black", size = 3, shape = 16),
  centrality.plotting = TRUE,
  centrality.type = type,
  centrality.line.args = list(color = "blue", linewidth = 1, linetype = "dashed"),
  ggplot.component = NULL,
  ggtheme = ggstatsplot::theme_ggstatsplot(),
  ...
)
}
\arguments{
\item{data}{A data frame (or a tibble) from which variables specified are to
be taken. Other data types (e.g., matrix,table, array, etc.) will \strong{not}
be accepted. Additionally, grouped data frames from \code{{dplyr}} should be
ungrouped before they are entered as \code{data}.}

\item{x}{A numeric variable from the data frame \code{data}.}

\item{y}{Label or grouping variable.}

\item{xlab}{Label for \code{x} axis variable. If \code{NULL} (default),
variable name for \code{x} will be used.}

\item{ylab}{Labels for \code{y} axis variable. If \code{NULL} (default),
variable name for \code{y} will be used.}

\item{title}{The text for the plot title.}

\item{subtitle}{The text for the plot subtitle. Will work only if
\code{results.subtitle = FALSE}.}

\item{caption}{The text for the plot caption. This argument is relevant only
if \code{bf.message = FALSE}.}

\item{type}{A character specifying the type of statistical approach:
\itemize{
\item \code{"parametric"}
\item \code{"nonparametric"}
\item \code{"robust"}
\item \code{"bayes"}
}

You can specify just the initial letter.}

\item{test.value}{A number indicating the true value of the mean (Default:
\code{0}).}

\item{bf.prior}{A number between \code{0.5} and \code{2} (default \code{0.707}), the prior
width to use in calculating Bayes factors and posterior estimates. In
addition to numeric arguments, several named values are also recognized:
\code{"medium"}, \code{"wide"}, and \code{"ultrawide"}, corresponding to \emph{r} scale values
of 1/2, sqrt(2)/2, and 1, respectively. In case of an ANOVA, this value
corresponds to scale for fixed effects.}

\item{bf.message}{Logical that decides whether to display Bayes Factor in
favor of the \emph{null} hypothesis. This argument is relevant only \strong{for
parametric test} (Default: \code{TRUE}).}

\item{effsize.type}{Type of effect size needed for \emph{parametric} tests. The
argument can be \code{"d"} (for Cohen's \emph{d}) or \code{"g"} (for Hedge's \emph{g}).}

\item{conf.level}{Scalar between \code{0} and \code{1} (default: \verb{95\%}
confidence/credible intervals, \code{0.95}). If \code{NULL}, no confidence intervals
will be computed.}

\item{tr}{Trim level for the mean when carrying out \code{robust} tests. In case
of an error, try reducing the value of \code{tr}, which is by default set to
\code{0.2}. Lowering the value might help.}

\item{digits}{Number of digits for rounding or significant figures. May also
be \code{"signif"} to return significant figures or \code{"scientific"}
to return scientific notation. Control the number of digits by adding the
value as suffix, e.g. \code{digits = "scientific4"} to have scientific
notation with 4 decimal places, or \code{digits = "signif5"} for 5
significant figures (see also \code{\link[=signif]{signif()}}).}

\item{results.subtitle}{Decides whether the results of statistical tests are
to be displayed as a subtitle (Default: \code{TRUE}). If set to \code{FALSE}, only
the plot will be returned.}

\item{point.args}{A list of additional aesthetic arguments passed to
\code{geom_point}.}

\item{centrality.plotting}{Logical that decides whether centrality tendency
measure is to be displayed as a point with a label (Default: \code{TRUE}).
Function decides which central tendency measure to show depending on the
\code{type} argument.
\itemize{
\item \strong{mean} for parametric statistics
\item \strong{median} for non-parametric statistics
\item \strong{trimmed mean} for robust statistics
\item \strong{MAP estimator} for Bayesian statistics
}

If you want default centrality parameter, you can specify this using
\code{centrality.type} argument.}

\item{centrality.type}{Decides which centrality parameter is to be displayed.
The default is to choose the same as \code{type} argument. You can specify this
to be:
\itemize{
\item \code{"parameteric"} (for \strong{mean})
\item \code{"nonparametric"} (for \strong{median})
\item \code{robust} (for \strong{trimmed mean})
\item \code{bayes} (for \strong{MAP estimator})
}

Just as \code{type} argument, abbreviations are also accepted.}

\item{centrality.line.args}{A list of additional aesthetic arguments to be
passed to the \code{geom_line} used to display the lines corresponding to the
centrality parameter.}

\item{ggplot.component}{A \code{ggplot} component to be added to the plot prepared
by \code{{ggstatsplot}}. This argument is primarily helpful for \code{grouped_}
variants of all primary functions. Default is \code{NULL}. The argument should
be entered as a \code{{ggplot2}} function or a list of \code{{ggplot2}} functions.}

\item{ggtheme}{A \code{{ggplot2}} theme. Default value is
\code{ggstatsplot::theme_ggstatsplot()}. Any of the \code{{ggplot2}} themes (e.g.,
\code{theme_bw()}), or themes from extension packages are allowed (e.g.,
\code{ggthemes::theme_fivethirtyeight()}, \code{hrbrthemes::theme_ipsum_ps()}, etc.).
But note that sometimes these themes will remove some of the details that
\code{{ggstatsplot}} plots typically contains. For example, if relevant,
\code{ggbetweenstats()} shows details about multiple comparison test as a label
on the secondary Y-axis. Some themes (e.g.
\code{ggthemes::theme_fivethirtyeight()}) will remove the secondary Y-axis and
thus the details as well.}

\item{...}{Currently ignored.}
}
\description{
A dot chart (as described by William S. Cleveland) with statistical details
from one-sample test.
}
\details{
For details, see:
\url{https://indrajeetpatil.github.io/ggstatsplot/articles/web_only/ggdotplotstats.html}
}
\section{Summary of graphics}{
\tabular{lll}{
   graphical element \tab \code{geom} used \tab argument for further modification \cr
   histogram bin \tab \code{ggplot2::stat_bin()} \tab \code{bin.args} \cr
   centrality measure line \tab \code{ggplot2::geom_vline()} \tab \code{centrality.line.args} \cr
   normality curve \tab \code{ggplot2::stat_function()} \tab \code{normal.curve.args} \cr
}
}

\section{One-sample tests}{



The table below provides summary about:
\itemize{
\item statistical test carried out for inferential statistics
\item type of effect size estimate and a measure of uncertainty for this estimate
\item functions used internally to compute these details
}

\strong{Hypothesis testing}\tabular{lll}{
   Type \tab Test \tab Function used \cr
   Parametric \tab One-sample Student's \emph{t}-test \tab \code{stats::t.test()} \cr
   Non-parametric \tab One-sample Wilcoxon test \tab \code{stats::wilcox.test()} \cr
   Robust \tab Bootstrap-\emph{t} method for one-sample test \tab \code{WRS2::trimcibt()} \cr
   Bayesian \tab One-sample Student's \emph{t}-test \tab \code{BayesFactor::ttestBF()} \cr
}


\strong{Effect size estimation}\tabular{llll}{
   Type \tab Effect size \tab CI available? \tab Function used \cr
   Parametric \tab Cohen's \emph{d}, Hedge's \emph{g} \tab Yes \tab \code{effectsize::cohens_d()}, \code{effectsize::hedges_g()} \cr
   Non-parametric \tab \emph{r} (rank-biserial correlation) \tab Yes \tab \code{effectsize::rank_biserial()} \cr
   Robust \tab trimmed mean \tab Yes \tab \code{WRS2::trimcibt()} \cr
   Bayes Factor \tab difference \tab Yes \tab \code{bayestestR::describe_posterior()} \cr
}

}

\examples{
\dontshow{if (identical(Sys.getenv("NOT_CRAN"), "true")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# for reproducibility
set.seed(123)

# creating a plot
p <- ggdotplotstats(
  data = ggplot2::mpg,
  x = cty,
  y = manufacturer,
  title = "Fuel economy data",
  xlab = "city miles per gallon"
)

# looking at the plot
p

# extracting details from statistical tests
extract_stats(p)
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link{grouped_gghistostats}}, \code{\link{gghistostats}},
\code{\link{grouped_ggdotplotstats}}
}
