% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_epicurve.R
\docType{data}
\name{geom_epicurve}
\alias{geom_epicurve}
\alias{stat_bin_date}
\alias{stat_date_count}
\alias{StatEpicurve}
\alias{StatBinDate}
\alias{StatDateCount}
\title{Create an epidemic curve plot or used date binning of observations}
\usage{
geom_epicurve(
  mapping = NULL,
  data = NULL,
  stat = "epicurve",
  position = "stack",
  date_resolution = NULL,
  week_start = getOption("lubridate.week.start", 1),
  width = NULL,
  relative.width = 1,
  ...,
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE
)

stat_bin_date(
  mapping = NULL,
  data = NULL,
  geom = "line",
  position = "stack",
  date_resolution = NULL,
  week_start = getOption("lubridate.week.start", 1),
  ...,
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE
)

stat_date_count(
  mapping = NULL,
  data = NULL,
  geom = "line",
  position = "stack",
  date_resolution = NULL,
  week_start = getOption("lubridate.week.start", 1),
  ...,
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2]{aes}}. Commonly used mappings:
\itemize{
\item \strong{x or y}: date or datetime. Numeric is technically supported.
\item \strong{fill}: for colouring groups
\item \strong{weight}: if data is already aggregated (e.g. case counts)
}}

\item{data}{The data frame containing the variables for the plot}

\item{stat}{either "\code{epicurve}" for outlines around cases or "\code{date_bin}" for outlines around (fill) groups.
For large numbers of cases please use "\code{date_bin}" to reduce number of drawn rectangles.}

\item{position}{Position adjustment. Currently supports "\code{stack}".}

\item{date_resolution}{Character string specifying the time unit for date aggregation.
Set to \code{NULL} or \code{NA} for no date aggregation \cr
Possible values are: \code{"day"}, \code{"week"}, \code{"month"}, \code{"bimonth"}, \code{"season"}, \code{"quarter"}, \code{"halfyear"}, \code{"year"}.
To special values enforce ISO or US week standard:
\itemize{
\item \code{isoweek} will force \code{dadte_resolution = week} and \code{week_start = 1} (ISO and ECDC Standard)
\item \code{epiweek} will force \code{date_resolution = week} and \code{week_start = 7} (US CDC Standard)
}}

\item{week_start}{Integer specifying the start of the week (1 = Monday, 7 = Sunday). \cr
Only used when date_resolution includes weeks. Defaults to 1 (Monday). \cr
For isoweek use \code{week_start = 1} and for epiweek use \code{week_start = 7}.}

\item{width}{Numeric value specifying the width of the bars. If \code{NULL}, calculated
based on resolution and relative.width}

\item{relative.width}{Numeric value between 0 and 1 adjusting the relative width
of bars. Defaults to 1}

\item{...}{Other arguments passed to \code{\link[ggplot2]{layer}}. For example:
\itemize{
\item \code{colour} Colour of the outlines around cases. Disable with colour = NA. Defaults to "white".
\item \code{linewidth}  Width of the case outlines.
}}

\item{na.rm}{If \code{FALSE}, the default, missing values are removed with
a warning. If \code{TRUE}, missing values are silently removed.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[ggplot2:borders]{borders()}}.}

\item{geom}{The geometric object to use to display the data for this layer.
When using a \verb{stat_*()} function to construct a layer, the \code{geom} argument
can be used to override the default coupling between stats and geoms.}
}
\value{
A \code{ggplot2} geom layer that can be added to a plot
}
\description{
Creates a epicurve plot for visualizing epidemic case counts in outbreaks (epidemiological curves).
An epicurve is a bar plot, where every case is outlined. \code{geom_epicurve} additionally provides
date-based aggregation of cases (e.g. per week or month and many more).
\itemize{
\item For week aggregation both isoweek (World + ECDC) and epiweek (US CDC) are supported.
\item \code{stat_bin_date} and its alias \code{stat_date_count} provide date based binning only. After binning the by date, these
stats behave like \link[ggplot2:geom_bar]{ggplot2::stat_count}.
}
}
\details{
Epi Curves are a public health tool for outbreak investigation. For more details see the references.
}
\examples{
# Basic epicurve with dates
library(ggplot2)
set.seed(1)

plot_data_epicurve_imp <- data.frame(
  date = rep(as.Date("2023-12-01") + ((0:300) * 1), times = rpois(301, 0.5))
)

ggplot(plot_data_epicurve_imp, aes(x = date, weight = 2)) +
  geom_vline_year(year_break = "01-01", show.legend = TRUE) +
  geom_epicurve(date_resolution = "week") +
  labs(title = "Epicurve Example") +
  scale_y_cases_5er() +
  scale_x_date(date_breaks = "4 weeks", date_labels = "W\%V'\%g") + # Correct ISOWeek labels week'year
  coord_equal(ratio = 7) + # Use coord_equal for square boxes. 'ratio' are the days per week.
  theme_bw()

# Categorical epicurve
library(tidyr)
library(outbreaks)

sars_canada_2003 |> # SARS dataset from outbreaks
  pivot_longer(starts_with("cases"), names_prefix = "cases_", names_to = "origin") |>
  ggplot(aes(x = date, weight = value, fill = origin)) +
  geom_epicurve(date_resolution = "week") +
  scale_x_date(date_labels = "W\%V'\%g", date_breaks = "2 weeks") +
  scale_y_cases_5er() +
  theme_classic()
}
\references{
\itemize{
\item Centers for Disease Control and Prevention. Quick-Learn Lesson:
Using an Epi Curve to Determine Mode of Spread. USA. \url{https://www.cdc.gov/training/quicklearns/epimode/}
\item Dicker, Richard C., Fátima Coronado, Denise Koo, and R. Gibson Parrish. 2006.
Principles of Epidemiology in Public Health Practice; an Introduction to Applied Epidemiology and Biostatistics.
3rd ed. USA. \url{https://stacks.cdc.gov/view/cdc/6914}
}
}
\seealso{
\code{\link[=scale_y_cases_5er]{scale_y_cases_5er()}}, \code{\link[=geom_vline_year]{geom_vline_year()}}
}
\keyword{datasets}
