\name{ggsave}
\alias{ggsave}
\title{Save a ggplot with sensible defaults (ggtern version)}
\usage{
ggsave(filename = default_name(), plot = last_plot(),
  device = default_device(filename), path = NULL, scale = 1,
  width = par("din")[1], height = par("din")[2], units = c("in", "cm",
  "mm"), dpi = 300, limitsize = TRUE, ...)
}
\arguments{
  \item{filename}{file name/filename of plot}

  \item{plot}{plot to save, defaults to last plot
  displayed}

  \item{device}{device to use, automatically extract from
  file name extension}

  \item{path}{path to save plot to (if you just want to set
  path and not filename)}

  \item{scale}{scaling factor}

  \item{width}{width (defaults to the width of current
  plotting window)}

  \item{height}{height (defaults to the height of current
  plotting window)}

  \item{units}{units for width and height when either one
  is explicitly specified (in, cm, or mm)}

  \item{dpi}{dpi to use for raster graphics}

  \item{limitsize}{when \code{TRUE} (the default),
  \code{ggsave} will not save images larger than 50x50
  inches, to prevent the common error of specifying
  dimensions in pixels.}

  \item{...}{other arguments passed to graphics device}
}
\description{
ggsave is a convenient function for saving a plot.  It
defaults to saving the last plot that you displayed, and
for a default size uses the size of the current graphics
device.  It also guesses the type of graphics device from
the extension.  This means the only argument you need to
supply is the filename.
}
\details{
\code{ggsave} currently recognises the extensions eps/ps,
tex (pictex), pdf, jpeg, tiff, png, bmp, svg and wmf
(windows only).
}
\examples{
\donttest{
plot <- ggtern(data=Feldspar,aes(An,Ab,Or)) + geom_point() + theme_rgbw()
ggsave(plot,filename='test.png')
}
}

