% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/few.R
\name{theme_few}
\alias{theme_few}
\title{Theme based on Few's "Practical Rules for Using Color in Charts"}
\usage{
theme_few(base_size = 12, base_family = "")
}
\arguments{
\item{base_size}{base font size}

\item{base_family}{base font family}
}
\description{
Theme based on the rules and examples in
Stephen Few, "Practical Rules for Using Color in Charts"
}
\examples{
library("ggplot2")
p <- ggplot(mtcars) + geom_point(aes(x = wt, y = mpg,
    colour=factor(gear))) + facet_wrap(~am)
p + theme_few() + scale_colour_few()
p + theme_few() + scale_colour_few("light")
p + theme_few() + scale_colour_few("dark")

}
\references{
Stephen Few, "Practical Rules for Using Color in Charts",
\url{http://www.perceptualedge.com/articles/visual_business_intelligence/rules_for_using_color.pdf}.
}
