% Generated by roxygen2 (4.0.1): do not edit by hand
\name{dplyr-ggvis}
\alias{arrange.ggvis}
\alias{dplyr-ggvis}
\alias{filter.ggvis}
\alias{groups.ggvis}
\alias{mutate.ggvis}
\alias{regroup.ggvis}
\alias{select.ggvis}
\alias{summarise.ggvis}
\alias{ungroup.ggvis}
\title{Dplyr verbs for ggvis.}
\usage{
groups.ggvis(x)

regroup.ggvis(x, value)

ungroup.ggvis(x)

summarise.ggvis(.data, ...)

mutate.ggvis(.data, ...)

arrange.ggvis(.data, ...)

select.ggvis(.data, ...)

\method{filter}{ggvis}(.data, ...)
}
\description{
Reactive components must be wrapped in \code{eval} - this makes it
possible to separate out the non-standard evaluation of dplyr and ggvis.
}
\examples{
library(dplyr)
base <- mtcars \%>\% ggvis(~mpg, ~cyl) \%>\% layer_points()
base \%>\% group_by(cyl) \%>\% summarise(mpg = mean(mpg)) \%>\%
  layer_points(fill := "red", size := 100)

base \%>\% filter(mpg > 25) \%>\% layer_points(fill := "red")

base \%>\% mutate(cyl = jitter(cyl)) \%>\% layer_points(fill := "red")

# Dynamically restrict range using filter
mtcars \%>\% ggvis(~disp, ~mpg) \%>\%
   filter(cyl > eval(input_slider(0, 10))) \%>\%
   layer_points()

# Dynamically compute box-cox transformation with mutate
bc <- function(x, lambda) {
  if (abs(lambda) < 1e-6) log(x) else (x ^ lambda - 1) / lambda
}
bc_slider <- input_slider(-2, 2, 1, step = 0.1)
mtcars \%>\%
 ggvis(~disp, ~mpg) \%>\%
 mutate(disp = bc(disp, eval(bc_slider))) \%>\%
 layer_points()
}
\keyword{internal}

