% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gh_whoami.R
\name{gh_whoami}
\alias{gh_whoami}
\title{Info on current GitHub user and token}
\usage{
gh_whoami(.token = NULL, .api_url = NULL, .send_headers = NULL)
}
\arguments{
\item{.token}{Authentication token. Defaults to \code{GITHUB_PAT} or
\code{GITHUB_TOKEN} environment variables, in this order if any is set.
See \code{\link[=gh_token]{gh_token()}} if you need more flexibility, e.g. different tokens
for different GitHub Enterprise deployments.}

\item{.api_url}{Github API url (default: \url{https://api.github.com}). Used
if \code{endpoint} just contains a path. Defaults to \code{GITHUB_API_URL}
environment variable if set.}

\item{.send_headers}{Named character vector of header field values
(except \code{Authorization}, which is handled via \code{.token}). This can be
used to override or augment the default \code{User-Agent} header:
\code{"https://github.com/r-lib/gh"}.}
}
\value{
A \code{gh_response} object, which is also a \code{list}.
}
\description{
Reports wallet name, GitHub login, and GitHub URL for the current
authenticated user, the first bit of the token, and the associated scopes.
}
\details{
Get a personal access token for the GitHub API from
\url{https://github.com/settings/tokens} and select the scopes necessary for
your planned tasks. The \code{repo} scope, for example, is one many are
likely to need. The token itself is a string of 40 letters and digits. You
can store it any way you like and provide explicitly via the \code{.token}
argument to \code{\link[=gh]{gh()}}.

However, many prefer to define an environment variable \code{GITHUB_PAT} (or
\code{GITHUB_TOKEN}) with this value in their \code{.Renviron} file. Add a
line that looks like this, substituting your PAT:\preformatted{GITHUB_PAT=8c70fd8419398999c9ac5bacf3192882193cadf2
}

Put a line break at the end! If you're using an editor that shows line
numbers, there should be (at least) two lines, where the second one is empty.
Restart R for this to take effect. Call \code{gh_whoami()} to confirm
success.

To get complete information on the authenticated user, call
\code{gh("/user")}.

For token management via API (versus the browser), use the
\href{https://docs.github.com/v3/oauth_authorizations/}{OAuth Authorizations API}.
This API requires Basic Authentication using your username and password,
not tokens, and is outside the scope of the gh package.
}
\examples{
\dontshow{if (identical(Sys.getenv("IN_PKGDOWN"), "true")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
gh_whoami()
\dontshow{\}) # examplesIf}
\dontshow{if (FALSE) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
## explicit token + use with GitHub Enterprise
gh_whoami(.token = "8c70fd8419398999c9ac5bacf3192882193cadf2",
          .api_url = "https://github.foobar.edu/api/v3")
\dontshow{\}) # examplesIf}
}
