% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{plot.ghcm}
\alias{plot.ghcm}
\title{Plotting function for the \code{ghcm}-class.}
\usage{
\method{plot}{ghcm}(x, bw = "SJ", ...)
}
\arguments{
\item{x}{\code{ghcm}-object. The result of running a \code{ghcm_test}.}

\item{bw}{a string or numeric. If \code{bw} is a string, it should specify
a bandwidth method for the \code{density} function in the \pkg{stats}
package. If \code{bw} is a numeric, it will be used as the bandwidth in
the call to \code{density}.}

\item{...}{additional plotting parameters.}
}
\value{
None.
}
\description{
Plots the observed test statistic of a performed GHCM test together with a
density estimate of the estimated asymptotic distribution of the test
statistic under the null.
}
\examples{
set.seed(1)
library(refund)
data(ghcm_sim_data)

# Test independence of two scalars given a functional variable

m_1 <- pfr(Y_1 ~ lf(Z), data=ghcm_sim_data)
m_2 <- pfr(Y_2 ~ lf(Z), data=ghcm_sim_data)
test <- ghcm_test(resid(m_1), resid(m_2), X_grid = NA, Y_grid = NA )
plot(test)

}
