% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{as_tokens}
\alias{as_tokens}
\title{Create a list of tokens}
\usage{
as_tokens(
  tbl,
  token_field = "token",
  pos_field = get_dict_features()[1],
  nm = NULL
)
}
\arguments{
\item{tbl}{A tibble of tokens out of \code{tokenize()}.}

\item{token_field}{<\code{\link[rlang:args_data_masking]{data-masked}}>
Column name that contains tokens.}

\item{pos_field}{Feature name that will be kept as the names
of tokens. If you don't need them, give a \code{NULL} for this argument.}

\item{nm}{Names of returned list.
If left with \code{NULL}, "doc_id" field of \code{tbl} is used instead.}
}
\value{
A named list of tokens.
}
\description{
Create a list of tokens
}
\examples{
\dontrun{
tokenize(
  data.frame(
    doc_id = seq_along(ginga[5:8]),
    text = ginga[5:8]
  )
) |>
  prettify(col_select = "POS1") |>
  as_tokens()
}
}
