% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GGM.R
\name{hgt}
\alias{hgt}
\title{Hard Graphical Thresholding Algorithm}
\usage{
hgt(x, size, active.entry = NULL, bcd.opt = list(max.iter = 10, eps = 0.001))
}
\arguments{
\item{x}{There are 2 options: (1) \code{x} is an \eqn{n} by \eqn{p} data matrix; (2) a \eqn{p} by \eqn{p} sample covariance matrix. The program automatically identifies the input matrix by checking the symmetry. (\eqn{n} is the sample size and \eqn{p} is the dimension.)}

\item{size}{A non-negative integer for determining the model size, i.e., the number of non-zero off-diagonal entries in the upper-triangular precision matrix,
which is also the number of edges in the graph. \code{size} must range from 0 to \eqn{(p^2 - p) / 2}.}

\item{active.entry}{Pre-determined non-zero off-diagonal entries positions of the precision matrix. Default: \code{active.entry = NULL}.}

\item{bcd.opt}{A list of options that control details of the block coordinate descent algorithm.}
}
\value{
A list with following components:
\item{\code{Omega}}{Estimated inverse covariance matrix.}
\item{\code{active.entry}}{The position of the non-zero off-diagonal entries of \code{Omega} in the upper-triangular part.}
}
\description{
Estimates sparse inverse covariance matrix.
}
\details{
Hard Graphical Thresholding (HGT) algorithm proceeds by thresholding the sample correlation matrix and
estimating the inverse covariance matrix with block coordinate descent algorithm.
HGT algorithm could recover the inverse covariance matrix given model size or given active entries.
When active entries are given directly, model fitting is the so-called covariance selection.
}
\note{
Either \code{size} or \code{active.entry} should be specified when function \code{hgt} is called.
If both arguments are given, \code{size} would be omitted and the inverse covariance matrix would be estimated based on the given \code{active.entry}.

If arguments \code{active.entry} is specified, only one of the entries in symmetric positions should be given.
}
\examples{
library(gif)

data("ar1")
p <- 100
non_zero_num <- sum(ar1[["Omega"]] != 0) - p
res <- hgt(ar1[["x"]], size = non_zero_num / 2)
}
\references{
Luo, Shikai, Rui Song, and Daniela Witten (2014). Sure Screening for Gaussian Graphical Models. arXiv preprint arXiv:1407.7819. URL https://arxiv.org/abs/1407.7819.

Dempster, A.P. (1972). Covariance Selection. Biometrics, 28(1), 157-175. doi:10.2307/2528966
}
