% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_decoder.R
\name{data_decoder}
\alias{data_decoder}
\title{Array Data Decoder}
\usage{
data_decoder(values, encoding = c("ASCII", "Base64Binary", "GZipBase64Binary",
  "ExternalFileBinary"), datatype = NULL, endian = c("little", "big",
  "LittleEndian", "BigEndian"), ext_filename = NULL, n = NULL)
}
\arguments{
\item{values}{text from XML of GIFTI image}

\item{encoding}{encoding of GIFTI values}

\item{datatype}{Passed to \code{\link{convert_binary_datatype}}}

\item{endian}{Endian to pass in \code{\link{readBin}}}

\item{ext_filename}{if \code{encoding = "ExternalFileBinary"}, then
this is the external filename}

\item{n}{number of values to read.  Relevant if
\code{encoding = "ExternalFileBinary"}}
}
\value{
Vector of values
}
\description{
Decodes values from a GIFTI image
}
\examples{
if (have_gifti_test_data()) {
   gii_files = download_gifti_data()
   L = gifti_list(gii_files[1])
   orig = L$DataArray$Data[[1]]
   encoding = attributes(L$DataArray)$Encoding
   datatype = attributes(L$DataArray)$DataType
   endian = attributes(L$DataArray)$Endian
   vals =  data_decoder(orig, encoding = encoding,
   datatype = datatype, endian = endian)
   enc = data_encoder(vals, encoding = encoding,
   datatype = datatype, endian = endian)
   enc == orig
}
}
