#' giscoR package
#'
#' \tabular{ll}{
#' Package: \tab giscoR \cr
#' Type: \tab Package\cr
#' Version: \tab See sessionInfo() or DESCRIPTION file\cr
#' Date: \tab 2020\cr
#' License: \tab GPL-3\cr
#' LazyLoad: \tab yes\cr
#' }
#'
#' @name giscoR-package
#' @aliases giscoR
#' @docType package
#' @description \if{html}{\figure{logo.png}{options: width=120 alt="giscoR logo" align='right'}}
#'
#' giscoR is a API package that helps to retrieve data from Eurostat - GISCO (the Geographic Information System of the COmmission)
#' @title Download geospatial data from GISCO API - Eurostat
#'
#' @author dieghernan, \url{https://github.com/dieghernan/}
#' @source \href{https://ec.europa.eu/eurostat/web/gisco/geodata/reference-data/administrative-units-statistical-units}{GISCO webpage}
#' @references
#' See \code{citation("giscoR")}
#' @seealso
#' Useful links:
#'  \itemize{
#'  \item \url{https://dieghernan.github.io/giscoR/}
#'  \item \url{https://github.com/dieghernan/giscoR}
#'  \item Report bugs at \url{https://github.com/dieghernan/giscoR/issues}
#'  }
#' @keywords package
#' @note COPYRIGHT NOTICE
#'
#' When data downloaded from
#' \href{https://ec.europa.eu/eurostat/web/gisco/geodata/reference-data/administrative-units-statistical-units}{this page}
#' is used in any printed or electronic publication,
#' in addition to any other provisions
#' applicable to the whole Eurostat website,
#' data source will have to be acknowledged
#' in the legend of the map and
#' in the introductory page of the publication
#' with the following copyright notice:
#' \itemize{
#' 	\item EN: (C) EuroGeographics for the administrative boundaries
#' 	\item FR: (C) EuroGeographics pour les limites administratives
#' 	\item DE: (C) EuroGeographics bezüglich der Verwaltungsgrenzen
#' }
#' For publications in languages other than
#' English, French or German,
#' the translation of the copyright notice
#' in the language of the publication shall be used.
#'
#' If you intend to use the data commercially,
#' please contact EuroGeographics for
#' information regarding their licence agreements.
NULL

# import stuffs
#' @importFrom utils download.file unzip read.csv2 menu
NULL
