% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gisco_get_airports.R
\name{gisco_get_airports}
\alias{gisco_get_airports}
\alias{gisco_get_ports}
\title{Get location of airports and ports from GISCO API}
\source{
\href{https://ec.europa.eu/eurostat/web/gisco/geodata/reference-data/transport-networks}{GISCO API}
}
\usage{
gisco_get_airports(year = "2013", country = NULL)

gisco_get_ports(year = "2013")
}
\arguments{
\item{year}{Year of reference.}

\item{country}{A list of countries, see \link{gisco_get_countries}}
}
\value{
A \code{POINT} object on EPSG:4326.
}
\description{
Loads a simple feature (\code{sf}) object from GISCO API entry point or your local library.
}
\details{
\code{year} available:
\itemize{
   \item \code{gisco_get_airports} (\code{2006,2013})
   \item \code{gisco_get_ports} (\code{2009,2013})
   }

 Ports 2009 contains worldwide information, the rest of datasets refer
 to Europe. All shapefiles provided in EPSG:4326
}
\examples{
library(sf)

NL <- gisco_get_countries(country = "NL")
AirP_NL <- gisco_get_airports(country = "NL")

Ports <- gisco_get_ports()
# Intersect with NL
PortsNL <- st_intersection(Ports, NL)


plot(st_geometry(NL), bg = "lightblue1", col = "wheat")
plot(
  st_geometry(PortsNL),
  pch = 22,
  col = "forestgreen",
  add = TRUE,
  cex = 0.8
)

plot(
  st_geometry(AirP_NL),
  pch = 20,
  col = "steelblue",
  add = TRUE,
  cex = 1.2
)
legend(
  "topright",
  legend = c("Port", "Airport"),
  col = c("forestgreen", "steelblue"),
  cex = 0.9,
  bty = "n",
  pch = c(22, 20),
  pt.cex = c(1, 1.5),
  y.intersp = 2
)

title(
  main = "Transport Network on the Nethelands",
  sub = gisco_attributions(),
  line = 1,
  cex.sub = 0.7,
  font.sub = 3
)
}
\author{
dieghernan, \url{https://github.com/dieghernan/}
}
