% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gisco_get_grid.R
\name{gisco_get_grid}
\alias{gisco_get_grid}
\title{Get the grid cells covering the European land territory, for various resolutions.}
\source{
\href{https://ec.europa.eu/eurostat/web/gisco/geodata/reference-data/grids}{GISCO API Grids}
}
\usage{
gisco_get_grid(
  resolution = "20",
  spatialtype = "REGION",
  cache_dir = NULL,
  update_cache = FALSE,
  verbose = FALSE
)
}
\arguments{
\item{resolution}{Resolution of the grid cells on kms. Available values are
\code{1, 2, 5, 10, 20, 50, 100}. See Details}

\item{spatialtype}{Select one of \code{REGION,POINT}}

\item{cache_dir, update_cache, verbose}{See \link{gisco_get}}
}
\value{
A \code{POLYGON/POINT} object.
}
\description{
These datasets contain grid cells covering the European land territory, for various resolutions from 1km to 100km. Base statistics such as population figures are provided for these cells.
}
\details{
Files are distributed on EPSG:3035.

  The file sizes range is from 428K (\code{resolution = "100"})
to 1.7G \code{resolution = "1"}. For resolutions 1km and 2km you would
need to confirm the download.
}
\note{
There are specific downloading provisions, please see \url{https://ec.europa.eu/eurostat/web/gisco/geodata/reference-data/grids}
}
\examples{
library(sf)

grid <- gisco_get_grid(resolution = 20)
grid$popdens <- grid$TOT_P_2011/20

breaks <-
  c(0,
    500,
    1000,
    2500,
    5000,
    10000,
    25000,
    50000,
    max(grid$popdens) + 1)

pal <- hcl.colors(length(breaks)-2, palette = "inferno", alpha = 0.7)
pal <- c("black",pal)

opar <- par(no.readonly = TRUE)
par(mar=c(0,0,0,0), bg = "grey2")
plot(
  grid[, "popdens"],
  pal = pal,
  key.pos = NULL,
  breaks = breaks,
  main = NA,
  xlim = c(2500000, 7000000),
  ylim = c(1500000 , 5200000),
  border = NA
)
par(opar)
}
\author{
dieghernan, \url{https://github.com/dieghernan/}
}
