% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gisco_get_lau.R
\name{gisco_get_lau}
\alias{gisco_get_lau}
\alias{gisco_get_communes}
\title{Get GISCO urban areas \code{\link[sf:sf]{sf}} polygons, points and lines}
\usage{
gisco_get_communes(
  year = "2016",
  epsg = "4326",
  cache = TRUE,
  update_cache = FALSE,
  cache_dir = NULL,
  verbose = FALSE,
  spatialtype = "RG",
  country = NULL
)

gisco_get_lau(
  year = "2021",
  epsg = "4326",
  cache = TRUE,
  update_cache = FALSE,
  cache_dir = NULL,
  verbose = FALSE,
  country = NULL,
  gisco_id = NULL
)
}
\arguments{
\item{year}{Release year of the file:
\itemize{
\item For \code{gisco_get_communes()} one of \code{"2001"}, \code{"2004"}, \code{"2006"}, \code{"2008"}, \code{"2010"}, \code{"2013"} or \code{"2016"}.
\item For \code{gisco_get_lau()} one of \code{"2011"}, \code{"2012"}, \code{"2013"}, \code{"2014"}, \code{"2015"}, \code{"2016"}, \code{"2017"}, \code{"2018"}, \code{"2019"}, \code{"2020"} or \code{"2021"}.
}}

\item{epsg}{projection of the map: 4-digit \href{https://epsg.io/}{EPSG code}.
One of:
\itemize{
\item \code{"4258"}: ETRS89
\item \code{"4326"}: WGS84
\item \code{"3035"}: ETRS89 / ETRS-LAEA
\item \code{"3857"}: Pseudo-Mercator
}}

\item{cache}{A logical whether to do caching. Default is \code{TRUE}. See
\strong{About caching}.}

\item{update_cache}{A logical whether to update cache. Default is \code{FALSE}.
When set to \code{TRUE} it would force a fresh download of the source
\code{.geojson} file.}

\item{cache_dir}{A path to a cache directory. See \strong{About caching}.}

\item{verbose}{Logical, displays information. Useful for debugging,
default is \code{FALSE}.}

\item{spatialtype}{Type of geometry to be returned:
\itemize{
\item \code{"BN"}: Boundaries - \code{LINESTRING} object.
\item \code{"COASTL"}: coastlines - \code{LINESTRING} object.
\item \code{"INLAND"}: inland boundaries - \code{LINESTRING} object.
\item \code{"LB"}: Labels - \code{POINT} object.
\item \code{"RG"}: Regions - \code{MULTIPOLYGON/POLYGON} object.
}

\strong{Note that} parameters \code{country} and \code{region} would be only applied
when \code{spatialtype} is \code{"BN"} or \code{"RG"}.}

\item{country}{Optional. A character vector of country codes. It could be
either a vector of country names, a vector of ISO3 country codes or a
vector of Eurostat country codes. Mixed types (as \code{c("Italy","ES","FRA")})
would not work. See also \code{\link[countrycode:countrycode]{countrycode::countrycode()}}.}

\item{gisco_id}{Optional. A character vector of GISCO_ID LAU values.}
}
\value{
A \code{\link[sf:sf]{sf}} object specified by \code{spatialtype}. In the case of
\code{\link[=gisco_get_lau]{gisco_get_lau()}}, a \code{POLYGON} object.
}
\description{
\code{\link[=gisco_get_communes]{gisco_get_communes()}} and \code{\link[=gisco_get_lau]{gisco_get_lau()}} download shapes of Local
Urban Areas, that correspond roughly with towns and cities.
}
\note{
Please check the download and usage provisions on \code{\link[=gisco_attributions]{gisco_attributions()}}.
}
\section{About caching}{
You can set your \code{cache_dir} with \code{\link[=gisco_set_cache_dir]{gisco_set_cache_dir()}}.

Sometimes cached files may be corrupt. On that case, try re-downloading
the data setting \code{update_cache = TRUE}.

If you experience any problem on download, try to download the
corresponding \code{.geojson} file by any other method and save it on your
\code{cache_dir}. Use the option \code{verbose = TRUE} for debugging the API query.

For a complete list of files available check \link{gisco_db}.
}

\examples{
\dontshow{if (gisco_check_access()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\donttest{

ire_lau <- gisco_get_communes(spatialtype = "LB", country = "Ireland")

if (!is.null(ire_lau)) {
  library(ggplot2)

  ggplot(ire_lau) +
    geom_sf(shape = 21, col = "#009A44", size = 0.5) +
    labs(
      title = "Communes in Ireland",
      subtitle = "Year 2016",
      caption = gisco_attributions()
    ) +
    theme_void() +
    theme(text = element_text(
      colour = "#009A44",
      family = "serif", face = "bold"
    ))
}
}
\dontshow{\}) # examplesIf}
}
\seealso{
Other political: 
\code{\link{gisco_bulk_download}()},
\code{\link{gisco_get_coastallines}()},
\code{\link{gisco_get_countries}()},
\code{\link{gisco_get_nuts}()},
\code{\link{gisco_get_postalcodes}()},
\code{\link{gisco_get_units}()},
\code{\link{gisco_get_urban_audit}()}
}
\concept{political}
