% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gisco_clear_cache.R
\name{gisco_clear_cache}
\alias{gisco_clear_cache}
\title{Clear your \CRANpkg{giscoR} cache dir}
\usage{
gisco_clear_cache(config = FALSE, cached_data = TRUE, verbose = FALSE)
}
\arguments{
\item{config}{if \code{TRUE}, will delete the configuration folder of
\CRANpkg{giscoR}.}

\item{cached_data}{If this is set to \code{TRUE}, it will delete your
\code{cache_dir} and all its content.}

\item{verbose}{Logical, displays information. Useful for debugging,
default is \code{FALSE}.}
}
\value{
Invisible. This function is called for its side effects.
}
\description{
\strong{Use this function with caution}. This function would clear your cached
data and configuration, specifically:
\itemize{
\item Deletes the \CRANpkg{giscoR} config directory
(\code{rappdirs::user_config_dir("giscoR", "R")}).
\item Deletes the \code{cache_dir} directory.
\item Deletes the values on stored on \code{Sys.getenv("GISCO_CACHE_DIR")} and
\code{options(gisco_cache_dir)}.
}
}
\details{
This is an overkill function that is intended to reset your status
as it you would never have installed and/or used \CRANpkg{giscoR}.
}
\examples{

# Don't run this! It would modify your current state
\dontrun{
gisco_clear_cache(verbose = TRUE)

Sys.getenv("GISCO_CACHE_DIR")

# Set new cache on a temp dir
newcache <- file.path(tempdir(), "giscoR", "pkgdown")

newcache

gisco_set_cache_dir(newcache)

Sys.getenv("GISCO_CACHE_DIR")
}
}
\seealso{
\code{\link[rappdirs:user_data_dir]{rappdirs::user_config_dir()}}

Other cache utilities: 
\code{\link{gisco_set_cache_dir}()}
}
\concept{cache utilities}
