% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/push.r
\docType{methods}
\name{push}
\alias{push}
\alias{push,git_branch-method}
\alias{push,git_repository-method}
\title{Push}
\usage{
push(object, ...)

\S4method{push}{git_branch}(object, credentials = NULL)

\S4method{push}{git_repository}(object, name = NULL, refspec = NULL,
  credentials = NULL)
}
\arguments{
\item{object}{S4 class \code{git_repository} or \code{git_branch}.}

\item{...}{Additional arguments affecting the push.}

\item{credentials}{The credentials for remote repository
access. Default is NULL.}

\item{name}{The remote's name. Default is NULL.}

\item{refspec}{The refspec to be pushed. Default is NULL.}
}
\value{
invisible(NULL)
}
\description{
Push
}
\examples{
\dontrun{
## Initialize two temporary repositories
path_bare <- tempfile(pattern="git2r-")
path_repo <- tempfile(pattern="git2r-")
dir.create(path_bare)
dir.create(path_repo)
repo_bare <- init(path_bare, bare = TRUE)
repo <- clone(path_bare, path_repo)

## Config user and commit a file
config(repo, user.name="Alice", user.email="alice@example.org")

## Write to a file and commit
writeLines("Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do",
           file.path(path_repo, "example.txt"))
add(repo, "example.txt")
commit(repo, "First commit message")

## Push commits from repository to bare repository
## Adds an upstream tracking branch to branch 'master'
push(repo, "origin", "refs/heads/master")

## Change file and commit
writeLines(c("Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do",
             "eiusmod tempor incididunt ut labore et dolore magna aliqua."),
           file.path(path_repo, "example.txt"))
add(repo, "example.txt")
commit(repo, "Second commit message")

## Push commits from repository to bare repository
push(repo)

## List commits in repository and bare repository
commits(repo)
commits(repo_bare)
}
}
\seealso{
\code{\linkS4class{cred_user_pass}},
\code{\linkS4class{cred_ssh_key}}
}
\keyword{methods}

